#　ゲーム設定
module DarkHall

	class GameConfig < StorableObject
		include GetText
		

		DM_MONOCHROME = 0
		DM_COLORFUL = 1
		DM_TEXTURE = 2
		
		WE_NO = 'no'
		WE_SHAKE = 'shake'
		WE_OUCH = 'ouch'
		
		KEY_ASSIGN_CAPTIONS = {
			'Decide' => _("決定"),
			'Cancel' => _("キャンセル"),
			'PageUp' => _("前ページへ"),
			'PageDown' => _("次ページへ"),
			'PageMoveShift' => _("十字キーと同時押しでページ移動"),
			'LeftWalk' => _("左並行移動(ダンジョン内)"),
			'RightWalk' => _("右並行移動(ダンジョン内)"),
			'SideWalkShift' => _("十字キーと同時押しで並行移動"),
			'ActionMenu' => _("特殊行動メニュー"),
			'SystemMenu' => _("システムメニュー"),

		}
	
		attr_accessor :bgm_volume_level, :se_volume_level
		attr_accessor :shield_mark, :wall_effect
		bool_attr_accessor :mouse_operation, :dungeon_mapping, :back_turn, :command_description_visible
		bool_attr_accessor :wizardry_like_door_open
		attr_accessor :ttf_name, :ttf_size, :save_frequency_level
		attr_accessor :key_assign
		
		STORED_KEYS = %w(
			mouse_operation dungeon_mapping back_turn command_description_visible
			shield_mark wall_effect wizardry_like_door_open
			bgm_volume_level se_volume_level ttf_name ttf_size
			save_frequency_level
		)

		
		def initialize
			@bgm_volume_level = 8 # なぜか最大でないとノイズが入る
			@se_volume_level = 8
			
			@command_description_visible = true
		
			@mouse_operation = true
			@wizardry_like_door_open = false
			@shield_mark = "[s]"
			@wall_effect = WE_SHAKE
			@dungeon_mapping = DM_TEXTURE
			@back_turn = true
			@key_assign = {
				'Decide' => 1,
				'Cancel' => 2,
				'PageUp' => 6,
				'PageDown' => 7,
				'PageMoveShift' => nil,
				'LeftWalk' => 6,
				'RightWalk' => 7,
				'SideWalkShift' => nil,
				'SystemMenu' => 9,
				'ActionMenu' => nil,
			}
			
			@ttf_name = DEFAULT_TTF_NAME
			@ttf_size = 14
			@save_frequency_level = FQ_CHANGE
			
		end
		
		def difficulty_caption(value = @difficulty)
			DIFFICULTY_CAPTIONS[value]
		end
		
		def wizardry_like_door_open_caption(value = @wizardry_like_door_open)
			if value then
				_("決定キーで開ける")
			else
				_("自動で開ける")
			end
		end


		
		def wall_effect_caption(value = @wall_effect)
			case value
			when WE_NO
				_("なし")
			when WE_SHAKE
				_("振動")
			when WE_OUCH
				_("いてっ！")
			end
		end


		def dungeon_mapping_caption(value = @dungeon_mapping)
			case value
			when DM_MONOCHROME
				_("モノクロ線画")
			when DM_COLORFUL
				_("面画")
			when DM_TEXTURE
				_("テクスチャ画像")
			end
		end
		


		
		def bgm_volume
			@bgm_volume_level * 16
		end
		
		def se_volume
			@se_volume_level * 16
		end
		
		def update_volume
			if SDL.inited_system(SDL::INIT_AUDIO) == SDL::INIT_AUDIO then
				SDL::Mixer.set_volume_music(bgm_volume)
				SDL::Mixer.set_volume(-1, se_volume)
				return true
			else
				return false
			end
		end
		
		def load(data)
			
			STORED_KEYS.each do |key|
				instance_variable_set("@#{key}", data[key]) if data.include?(key)
			end
			
			@key_assign.update(data['key_assign'])
			update_volume
		end

	
		
		def dump
			hash = super
			
			STORED_KEYS.each do |key|
				hash[key] = instance_variable_get("@#{key}")
			end
			
			hash['key_assign'] = @key_assign

			
			return hash
		end
		
		def self.create_from_mpac_model(hash)
			re = self.new
			re.load(hash)
			
			re
		end

	end

	

end