require 'rarg'

module DarkHall
	module Game
		class DebugMonitor
			attr_accessor :window
			attr_accessor :totals_per_second, :last_totals
			attr_accessor :save_display_remaining_time
			attr_accessor :last_save_level, :last_save_scene_title
			
		
			def initialize
				@window = SmallTextWindow.new
				@window.width = $screen.w - SCREEN_WIDTH
				@window.height = SCREEN_HEIGHT
				@window.make_surface.set_position(SCREEN_WIDTH, 0)
				@window.has_frame = false
				
				@totals_per_second = {}
				clear_totals
				
				@save_display_remaining_time = 0
				@last_save_level = nil
				@last_save_scene_title = nil
			end
			
			def clear_totals
				@totals_per_second[:fps] = 0
				@totals_per_second[:blit_time] = 0.0
			end
			
			def on_every_frame(fps_timer, cyclic_frame_count, blit_time)
				@totals_per_second[:fps] += fps_timer.real_fps
				@totals_per_second[:blit_time] += blit_time
				
				
				if cyclic_frame_count % 30 == 0 then
					buf = ""
					hour = (GS.playing_time / 60 / 60).to_i
					min = (GS.playing_time / 60 - hour * 60).to_i
					sec = GS.playing_time - hour * 60 * 60 - min * 60
					buf << sprintf("%02d:%02d:%02d\n\n", hour, min, sec)

					buf << "FPS: #{@totals_per_second[:fps] / (FPS)}\n"
					#buf << "Blit Time: #{((@totals_per_second[:blit_time] * 1000) / (FPS / 2.0)).to_i}ms\n"
					clear_totals
					
					if @save_display_remaining_time == 0 then
						buf << "\n"
					else
						buf << "save - #{@last_save_scene_title}(#{@last_save_level})\n"
						@save_display_remaining_time -= 1
					end
					
					@window.update(buf)
				end
				

				@window.blit

			end
		end
	end
end

