# スモールバイン
enemy :SmallVine do
	@name_id = Nn_('スモールバイン', 'スモールバイン')
	@description = _('迷宮の床・壁・天井などに生息し、迷い込んだ人間を襲うツタ')
	@level = 1
	@hp_max = 18
	@exp_rate = 0.015 * 6
	@gold = 3

	@ability_growth = {STR => GLOW_D, TEC => GLOW_D, AGL => GLOW_E, WIL => GLOW_B, PSY => GLOW_B}
	@weapon = Weapon.new('ESmallVine')
	@defense = 4
	@damage_resists = {DT_BLOW => RES_STRONG, DT_SLASH => RES_WEAK, DT_HEAT => RES_VERY_WEAK}
	all_state_resist RES_WEAK
	@state_resists[SmashedState] = RES_PERFECT
	
	@ai_type = :vine
	@number_rank = NUM_A
end

# バンディット
enemy :Bandit do
	@name_id = Nn_('バンディット', 'バンディット')
	@description = _('宝物や追いはぎの対象を求めてうろつき回る盗賊')
	@level = 2
	@hp_max = 20
	@exp_rate = 0.03 * 6
	@gold = 6

	@ability_growth = {STR => GLOW_C, TEC => GLOW_C, AGL => GLOW_B, WIL => GLOW_F, PSY => GLOW_F}
	@weapon = Weapon.new('EBandit')
	@defense = 6
	@damage_resists = {}
	@state_resists = {SmashedState => RES_WEAK}
	mental_resist RES_WEAK
	
	@ai_type = :beast
	@number_rank = NUM_C
end

# スピリットヘッド
enemy :SpiritHead do
	@name_id = Nn_('スピリットヘッド', 'スピリットヘッド')
	@description = _('死者の怨念が集まり、生物に危害を加えるようになったもの')
	@level = 2
	@hp_max = 16
	@exp_rate = 0.025 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_C, TEC => GLOW_D, AGL => GLOW_D, WIL => GLOW_A, PSY => GLOW_A}
	@weapon = Weapon.new('ESpiritHead')
	@defense = 3
	@damage_resists = {}
	@ghost_body = true
	@state_resists = {SmashedState => RES_PERFECT}
	undead_resist
	
	@ai_type = :spirit
	@number_rank = NUM_D
end

# はぐれ術師
enemy :StraySorcerer do
	@name_id = Nn_('はぐれ術師', 'はぐれ術師')
	@description = _('正道を外れ、盗賊まがいの行いで生計を立てるようになった術師')
	@level = 2
	@hp_max = 20
	@exp_rate = 0.03 * 6
	@gold = 6

	@ability_growth = {STR => GLOW_F, TEC => GLOW_E, AGL => GLOW_C, WIL => GLOW_B, PSY => GLOW_B}
	@mp_max = {'Lightning' => 2, 'Freezing' => 3}
	@weapon = Weapon.new('EStraySorcerer')
	@defense = 3
	@state_resists = {SmashedState => RES_WEAK}
	mental_resist RES_WEAK
	
	@ai_type = :stray_sorcerer
	@number_rank = NUM_C
end


# インプ
enemy :Imp do
	@name_id = Nn_('インプ', 'インプ')
	@description = _('インプ')
	@description = _('有翼のタフな小悪魔。魔道師の手先として使われることが多い')
	@level = 3
	@hp_max = 45
	@exp_rate = 0.025 * 6
	@gold = 5

	@ability_growth = {STR => GLOW_C, TEC => GLOW_E, AGL => GLOW_D, WIL => GLOW_E, PSY => GLOW_D}
	@weapon = Weapon.new('EImp')
	@defense = 7
	@damage_resists = {}
	
	@ai_type = :imp
	@number_rank = NUM_D
end

# ルーフバード
enemy :RoofBird do
	@name_id = Nn_('ルーフバード', 'ルーフバード')
	@description = _('迷宮の天井にとまり、獲物を見つけると集団で襲いかかる獰猛な鳥')
	@level = 3
	@hp_max = 16
	@exp_rate = 0.015 * 6
	@gold = 6

	@ability_growth = {STR => GLOW_E, TEC => GLOW_C, AGL => GLOW_S, WIL => GLOW_C, PSY => GLOW_F}
	@weapon = Weapon.new('ERoofBird')
	@defense = 4
	@damage_resists = {}
	@state_resists = {SmashedState => RES_CRITICAL}
	mental_resist RES_WEAK
	
	@ai_type = :bird
	@number_rank = NUM_A
end

# コボルトワーカー
enemy :KoboltWorker do
	@name_id = Nn_('コボルトワーカー', 'コボルトワーカー')
	@description = _('鋭い爪とタフな肉体、そして知性を併せ持った獣人')
	@level = 4
	@hp_max = 40
	@exp_rate = 0.025 * 6
	@gold = 12
	@ability_growth = {STR => GLOW_C, TEC => GLOW_D, AGL => GLOW_D, WIL => GLOW_E, PSY => GLOW_D}
	
	@weapon = Weapon.new('EKoboltWorker')
	@defense = 8
	@damage_resists = {}
	
	@ai_type = :beast
	@number_rank = NUM_C
end

# コボルトリーダー
enemy :KoboltLeader do
	@name_id = Nn_('コボルトリーダー', 'コボルトリーダー')
	@description = _('コボルトワーカー達を率いるリーダー格の獣人')
	@level = 6
	@hp_max = 60
	@exp_rate = 0.04 * 6
	@gold = 20

	@ability_growth = {STR => GLOW_C, TEC => GLOW_D, AGL => GLOW_D, WIL => GLOW_E, PSY => GLOW_D}
	
	@weapon = Weapon.new('EKoboltLeader')
	@defense = 9
	@shield = Accessory.new('LeatherBuckler')
	@damage_resists = {}
	
	@ai_type = :kobolt_leader
	@number_rank = NUM_ONE
end

# ピクシー
enemy :Pixie do
	@name_id = Nn_('ピクシー', 'ピクシー')
	@description = _('ひらひらと飛び回る妖精。直接の危害は加えてこないが、いたずら好き')
	@level = 5
	@hp_max = 15
	@exp_rate = 0.03 * 6
	@gold = 20

	@ability_growth = {STR => GLOW_G, TEC => GLOW_D, AGL => GLOW_SS, WIL => GLOW_C, PSY => GLOW_B}
	@mp_max = {'Hypnosis' => 6}
	@weapon = nil
	@defense = 3
	@damage_resists = {}
	@state_resists = {SmashedState => RES_CRITICAL}
	
	@ai_type = :pixie
	@number_rank = NUM_E
end

# ブレードスケルトン
enemy :BladeSkelton do
	@name_id = Nn_('ブレードスケルトン', 'ブレードスケルトン')
	@description = _('さまよう骸骨。知性は乏しいが、動作は軍隊のように体系立っている')
	@level = 7
	@hp_max = 32
	@exp_rate = 0.03 * 6
	@gold = 15
	
	@ability_growth = {STR => GLOW_E, TEC => GLOW_C, AGL => GLOW_C, WIL => GLOW_F, PSY => GLOW_D}
	@weapon = Weapon.new('EBladeSkelton')
	@defense = 7
	@shield = Accessory.new('LeatherBuckler')
	@damage_resists = {DT_BLOW => RES_WEAK, DT_THRUST => RES_VERY_STRONG}
	@state_resists = {SmashedState => RES_VERY_WEAK}
	undead_resist
	mental_resist RES_STRONG
	
	@ai_type = :beast
	@number_rank = NUM_C
end

# スライム
enemy :Slime do
	@name_id = Nn_('スライム', 'スライム')
	@description = _('強力な毒を持った液状の単細胞生物')
	@level = 7
	@hp_max = 25
	@exp_rate = 0.06 * 6
	@gold = 8

	@ability_growth = {STR => GLOW_D, TEC => GLOW_E, AGL => GLOW_G, WIL => GLOW_B, PSY => GLOW_E}
	@weapon = Weapon.new('ESlime')
	@defense = 15
	@damage_resists = {DT_BLOW => RES_PERFECT}
	@state_resists = {SmashedState => RES_STRONG}
	@state_resists[PoisonState] = RES_PERFECT

	@ai_type = :slime
	@number_rank = NUM_E
end

# ゴースト
enemy :Ghost do
	@name_id = Nn_('ゴースト', 'ゴースト')
	@description = _('未練を残して死した者の亡霊。悪意は薄いが、不用意に近づくと死ぬ')
	@level = 8
	@hp_max = 23
	@exp_rate = 0.04 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_C, TEC => GLOW_D, AGL => GLOW_D, WIL => GLOW_A, PSY => GLOW_A}
	@weapon = nil
	@defense = 7
	@damage_resists = {}
	@ghost_body = true
	@state_resists = {SmashedState => RES_PERFECT, CurseState => RES_PERFECT}
	undead_resist
	
	@ai_type = :ghost
	@number_rank = NUM_C
end


enemy :StraySwordman do
	@name_id = Nn_('落ちぶれ剣士', '落ちぶれ剣士')
	@description = _('-')
	@level = 8
	@hp_max = 23
	@exp_rate = 0.04 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_C, TEC => GLOW_D, AGL => GLOW_D, WIL => GLOW_A, PSY => GLOW_A}
	@weapon = Weapon.new('EBladeSkelton')
	@defense = 7
	@damage_resists = {}
	@state_resists = {SmashedState => RES_PERFECT, CurseState => RES_PERFECT}
	
	@ai_type = :beast
	@number_rank = NUM_B
end

enemy :BranchedVine do
	@name_id = Nn_('ブランチドバイン', 'ブランチドバイン')
	@description = _('-')
	@level = 10
	@hp_max = 23
	@exp_rate = 0.04 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_C, TEC => GLOW_D, AGL => GLOW_D, WIL => GLOW_A, PSY => GLOW_A}
	@weapon = Weapon.new('ESmallVine')
	@defense = 7
	@damage_resists = {}
	@state_resists = {SmashedState => RES_PERFECT, CurseState => RES_PERFECT}
	
	@ai_type = :beast
	@number_rank = NUM_C
end

enemy :Zombie do
	@name_id = Nn_('ゾンビー', 'ゾンビー')
	@description = _('-')
	@level = 10
	@hp_max = 23
	@exp_rate = 0.04 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_C, TEC => GLOW_D, AGL => GLOW_D, WIL => GLOW_A, PSY => GLOW_A}
	@weapon = Weapon.new('ESmallVine')
	@defense = 7
	@damage_resists = {}
	@state_resists = {SmashedState => RES_PERFECT, CurseState => RES_PERFECT}
	
	@ai_type = :beast
	@number_rank = NUM_A
end


=begin
# 燃えさかる息吹
enemy :BlazingStorm do
	@name_id = Nn_('燃えさかる息吹', '燃えさかる息吹')
	@level = 13
	@hp_max = 70
	@exp_rate = 0.04 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_E, TEC => GLOW_C, AGL => GLOW_S, WIL => GLOW_C, PSY => GLOW_F}
	@weapon = Weapon.new('ERuinFeather')
	@defense = 7
	@damage_resists = {DT_HEAT => RES_PERFECT, DT_COLD => RES_VERY_WEAK}
	
	@ai_type = :blazing_storm
	@number_rank = NUM_D
end


# 凍てつく息吹
enemy :FreezingStorm do
	@name_id = Nn_('凍てつく息吹', '凍てつく息吹')
	@level = 13
	@hp_max = 70
	@exp_rate = 0.04 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_E, TEC => GLOW_C, AGL => GLOW_S, WIL => GLOW_C, PSY => GLOW_F}
	@weapon = Weapon.new('ERuinFeather')
	@defense = 7
	@damage_resists = {DT_HEAT => RES_VERY_WEAK, DT_COLD => RES_PERFECT}
	
	@ai_type = :freezing_storm
	@number_rank = NUM_D
end
=end

# ルーインフェザー
enemy :RuinFeather do
	@name_id = Nn_('ルーインフェザー', 'ルーインフェザー')
	@description = _('遺跡や墓所に棲みつく巨鳥。多少の攻撃ではひるまないが、ある種の音を苦手とする')
	@level = 10
	@hp_max = 240
	@exp_rate = 0.3 * 6
	@gold = 160
	@mp_max = {'Acceleration' => 6}


	@ability_growth = {STR => GLOW_C, TEC => GLOW_B, AGL => GLOW_A, WIL => GLOW_C, PSY => GLOW_C}
	@weapon = Weapon.new('ERuinFeather')
	@defense = 12
	@damage_resists = {}
	all_state_resist RES_VERY_STRONG

	
	@ai_type = :ruin_feather
	@number_rank = NUM_ONE
end

# ロストアーマー
enemy :LostArmor do
	@name_id = Nn_('ロストアーマー', 'ロストアーマー')
	@description = _('死者の魂が宿って動き出した鎧')
	@level = 13
	@hp_max = 320
	@exp_rate = 0.35 * 6
	@gold = 0

	@ability_growth = {STR => GLOW_S, TEC => GLOW_B, AGL => GLOW_C, WIL => GLOW_E, PSY => GLOW_E}
	@weapon = Weapon.new('ELostArmor')
	@shield = Accessory.new('ELostArmorGuarder')
	@defense = 17
	@damage_resists = {}
	all_state_resist RES_VERY_STRONG
	undead_resist
	@state_resists[SleepState] = RES_PERFECT

	
	@ai_type = :lost_armor
	@number_rank = NUM_ONE
end

