require 'wx'
require 'wxconstructor'

require 'gettext'

#MEMO: ToDo - show center on screen 

module DarkHall
	module Game
		def self.show_name_input_dialog(*args)
			NameInputDialog.call(*args)
		end
	end

	module NameInputDialog
		def self.call(message, default = nil)
			$tmp = {}
			App.new(message, default).main_loop
			return $tmp[:name]
		end
		
		
		class App < Wx::App
			include GetText
			
			
			def initialize(message, default)
				super()
				@message, @default = message, default
			end
			
			def on_init
				@dialog = MainDialog.new(@message, @default)
				@dialog.show_modal
				exit_main_loop
			end
		end
		
		class MainDialog < Wx::Dialog
			include GetText
			def initialize(message, default)
				super(nil, :title => _('名前の入力'))
				self.window_style |= Wx::STAY_ON_TOP
	
				topsz = nil
				construct_children do |dialog|
					widget Wx::Panel do
						topsz = vbox_sizer do
							expand
							border 8
							widget Wx::StaticText, :label => message
							text = widget Wx::TextCtrl, :name => 'name_input', :value => default
							text.set_focus
							
							hbox_sizer do
								stretch_spacer 1
								proportion 1
								but = widget Wx::Button, :label => _('決定')
								but.set_default
								dialog.evt_button(but, :on_decide)
								stretch_spacer 1
							end
						end
					end
				end
				
				topsz.fit(self)
			end
			
			def on_decide
				name = find_window_by_name('name_input').value
				$tmp[:name] = name
				close
			end
		end
	end
	
end
