/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery;

import junit.framework.TestCase;

import org.trix.cuery.util.CSSUtil;

import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSValidatorTest.java,v 1.0 2005/08/29 6:47:52 Teletha Exp $
 */
public class CSSValidatorTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.CSSValidator.validate(InputSource)'
     */
    public void testValidate() throws Exception {
        CSSValidator validator = new CSSValidator();
        InputSource source = CSSUtil.getSource("src/test/org/trix/cuery/cssValidator.css");

        CSSParseException[] exceptions = validator.validate(source);

        for (int i = 0; i < exceptions.length; i++) {
            //System.out.println(CSSUtil.getErrorMessage(exceptions[i]));
        }
        
        // count
        assertEquals(13, exceptions.length);

        // no definition
        assertEquals(17, exceptions[0].getLineNumber());
        assertEquals(23, exceptions[1].getLineNumber());
        
        // invalid value
        assertEquals(24, exceptions[2].getLineNumber());
    }

}
