/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import org.trix.cuery.util.CSSUtil;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: AbstractCSSLength.java,v 1.01 2005/09/14 22:16:44 Teletha Exp $
 */
public abstract class AbstractCSSLength extends AbstractCSSValue implements CSSLength {

    /**
     * Create AbstractCSSLength instance.
     * 
     * @param length A length.
     * @param previous A previous token.
     */
    public AbstractCSSLength(float length, CSSValue previous) {
        super(previous);

        this.floatValue = length;
        this.stringValue = CSSUtil.displayFloat(length);
    }

    /**
     * Create AbstractCSSLength instance.
     * 
     * @param length A length.
     * @param previous A previous token.
     */
    public AbstractCSSLength(String length, CSSValue previous) {
        super(previous);

        // check unit
        String unit = getDimensionUnitText();

        if (length.endsWith(unit)) {
            length = length.substring(0, length.length() - unit.length());
        }

        this.floatValue = Float.parseFloat(length);
        this.stringValue = CSSUtil.displayFloat(this.floatValue);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getFloatValue()
     */
    public float getFloatValue() {
        return floatValue;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getStringValue()
     */
    public String getStringValue() {
        return stringValue;
    }

    /**
     * @see org.w3c.dom.css.CSSValue#getCssText()
     */
    public String getCssText() {
        return stringValue + getDimensionUnitText();
    }
}
