/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.sac;

import org.w3c.css.sac.Locator;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: LocatorImpl.java,v 1.0 2005/08/29 4:50:25 Teletha Exp $
 */
public class LocatorImpl implements Locator {

    /** The URI. */
    private String uri;

    /** The line number. */
    private int line;

    /** The column munber. */
    private int column;

    /**
     * Create LocatorImpl instance.
     * 
     * @param uri A uri.
     * @param lineNumber A line number.
     * @param columnNumber A column number.
     */
    public LocatorImpl(String uri, int lineNumber, int columnNumber) {
        this.uri = uri;
        this.line = lineNumber;
        this.column = columnNumber;
    }

    /**
     * @see org.w3c.css.sac.Locator#getURI()
     */
    public String getURI() {
        return uri;
    }

    /**
     * @see org.w3c.css.sac.Locator#getLineNumber()
     */
    public int getLineNumber() {
        return line;
    }

    /**
     * @see org.w3c.css.sac.Locator#getColumnNumber()
     */
    public int getColumnNumber() {
        return column;
    }

}
