/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: HyphenTokensFilter.java,v 1.1 2005/07/29 10:07:21 Teletha Exp $
 */
public class HyphenTokensFilter extends TokensFilter {

    /**
     * Create HyphenTokensFilter instance.
     * 
     * @param name An attribute name.
     * @param value An attribute value.
     */
    public HyphenTokensFilter(String name, String value) {
        super(name, value);
    }

    /**
     * @see org.trix.cuery.filter.TokensFilter#acceptToken(java.lang.String)
     */
    protected boolean acceptToken(String token) {
        return token.equals(value) || token.startsWith(value + "-");
    }

    /**
     * @see org.w3c.css.sac.Condition#getConditionType()
     */
    public short getConditionType() {
        return SAC_BEGIN_HYPHEN_ATTRIBUTE_CONDITION;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "[" + name + "|=\"" + value + "\"]";
    }

}
