/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import org.trix.cuery.util.CSSUtil;

import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * DOCUMENT.
 * 
 * @TODO more filtable
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: ChildFilter.java,v 1.01 2005/11/17 06:29:43 Teletha Exp $
 */
public class ChildFilter implements Filter, DescendantSelector {

    /** The parent selector. */
    protected Filter parent;

    /** The current selector. */
    protected Filter filter;

    /**
     * Create ChildFilter instance.
     * 
     * @param parent A parent selector.
     * @param simpleSelector A current selector.
     */
    public ChildFilter(Selector parent, SimpleSelector simpleSelector) {
        this.parent = CSSUtil.convert(parent);
        this.filter = CSSUtil.convert(simpleSelector);
    }

    /**
     * @see org.w3c.css.sac.DescendantSelector#getAncestorSelector()
     */
    public Selector getAncestorSelector() {
        return parent;
    }

    /**
     * @see org.w3c.css.sac.DescendantSelector#getSimpleSelector()
     */
    public SimpleSelector getSimpleSelector() {
        return (SimpleSelector) filter;
    }

    /**
     * @see org.trix.cuery.filter.Filter#accept(org.w3c.dom.Element)
     */
    public boolean accept(Element target) {
        if (!filter.accept(target)) {
            return false;
        }

        Node node = target.getParentNode();

        // node type
        if (node == null || node.getNodeType() != Node.ELEMENT_NODE) {
            return false;
        }
        return parent.accept((Element) node);
    }

    /**
     * @see org.trix.cuery.filter.Filter#getSpecificity()
     */
    public int getSpecificity() {
        return parent.getSpecificity() + filter.getSpecificity();
    }

    /**
     * @see org.trix.cuery.filter.Filter#getState()
     */
    public int getState() {
        return 0;
    }

    /**
     * @see org.w3c.css.sac.Selector#getSelectorType()
     */
    public short getSelectorType() {
        return SAC_CHILD_SELECTOR;
    }

    /**
     * @see org.w3c.css.sac.Condition#getConditionType()
     */
    public short getConditionType() {
        return SAC_AND_CONDITION;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return parent + " > " + filter;
    }
}
