/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.dom.stylesheets;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.trix.cuery.sac.SACMediaListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class StyleSheetImpl
implements StyleSheet {
    private static final Pattern PI_DATA = Pattern.compile("([^=\"']+)=[\"']([^\"']*)[\"']");
    private String href;
    private String title;
    private String type;
    private Node owner;
    private MediaList list = new SACMediaListImpl();
    private boolean disabled = false;

    public StyleSheetImpl(ProcessingInstruction pi) throws DOMException {
        if (pi == null || !pi.getTarget().equals("xml-stylesheet")) {
            throw new DOMException(12, "The value 'xml-stylesheet' is only accepted.");
        }
        Matcher matcher = PI_DATA.matcher(pi.getData());
        while (matcher.find()) {
            String name = matcher.group(1).trim();
            String value = matcher.group(2);
            if (name.equals("href")) {
                this.href = value;
                continue;
            }
            if (name.equals("title")) {
                this.title = value;
                continue;
            }
            if (name.equals("type")) {
                this.type = value;
                continue;
            }
            if (!name.equals("media")) continue;
            this.list.setMediaText(value);
        }
        this.owner = pi.getOwnerDocument();
    }

    public String getType() {
        return this.type;
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public Node getOwnerNode() {
        return this.owner;
    }

    public StyleSheet getParentStyleSheet() {
        return null;
    }

    public String getHref() {
        return this.href;
    }

    public String getTitle() {
        return this.title;
    }

    public MediaList getMedia() {
        return this.list;
    }
}

