/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.trix.cuery.filter.Filter;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.util.DOMUtil;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CSSQuery {
    private static final CueryParser PARSER = new CueryParser();
    private final Document document;

    public CSSQuery(String path) throws IOException {
        this(new File(path));
    }

    public CSSQuery(File file) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public CSSQuery(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("The target document is null.");
        }
        this.document = document;
    }

    public boolean match(Element element, String expression) {
        return this.match(element, PARSER.parseSelector(expression));
    }

    public boolean match(Element element, Selector selector) {
        if (selector == null || element == null) {
            return false;
        }
        Filter filter = CSSUtil.convert(selector);
        return filter.accept(element);
    }

    public Set select(String expression) {
        return this.select(PARSER.parseSelector(expression));
    }

    public Set select(Selector selector) {
        return this.query(this.document, selector);
    }

    private Set query(Node source, Selector selector) {
        switch (selector.getSelectorType()) {
            case 11: {
                return this.queryChild(source, (DescendantSelector)selector);
            }
            case 10: {
                return this.queryDescendant(source, (DescendantSelector)selector);
            }
            case 12: {
                return this.queryDirect(source, (SiblingSelector)selector);
            }
            case 13: {
                return this.queryIndirect(source, (SiblingSelector)selector);
            }
        }
        return DOMUtil.retrieveElements(source, CSSUtil.convert(selector), true);
    }

    private Set queryChild(Node source, DescendantSelector selector) {
        Set results = this.query(source, selector.getAncestorSelector());
        if (results.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet container = new HashSet();
        Iterator iterator = results.iterator();
        Filter filter = CSSUtil.convert((Selector)selector.getSimpleSelector());
        while (iterator.hasNext()) {
            Element result = (Element)iterator.next();
            container.addAll(DOMUtil.retrieveElements(result, filter, false));
        }
        return container;
    }

    private Set queryDescendant(Node source, DescendantSelector selector) {
        Set results = this.query(source, selector.getAncestorSelector());
        if (results.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet container = new HashSet();
        Iterator iterator = results.iterator();
        Filter filter = CSSUtil.convert((Selector)selector.getSimpleSelector());
        while (iterator.hasNext()) {
            Element result = (Element)iterator.next();
            container.addAll(DOMUtil.retrieveElements(result, filter, true));
        }
        return container;
    }

    private Set queryDirect(Node source, SiblingSelector selector) {
        Set results = this.query(source, selector.getSelector());
        if (results.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<Element> container = new HashSet<Element>();
        Iterator iterator = results.iterator();
        Filter filter = CSSUtil.convert((Selector)selector.getSiblingSelector());
        while (iterator.hasNext()) {
            Element next = DOMUtil.getNextElement((Element)iterator.next());
            if (next == null || !filter.accept(next)) continue;
            container.add(next);
        }
        return container;
    }

    private Set queryIndirect(Node source, SiblingSelector selector) {
        Set results = this.query(source, selector.getSelector());
        if (results.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<Element> container = new HashSet<Element>();
        Iterator iterator = results.iterator();
        Filter filter = CSSUtil.convert((Selector)selector.getSiblingSelector());
        while (iterator.hasNext()) {
            Element next = DOMUtil.getNextElement((Element)iterator.next());
            while (next != null) {
                if (filter.accept(next)) {
                    container.add(next);
                }
                next = DOMUtil.getNextElement(next);
            }
        }
        return container;
    }
}

