package jp.sourceforge.csvparser;

import java.util.ArrayList;
import java.util.List;

public class MockCSVHandler implements CSVHandler {

    private List callList;

    public MockCSVHandler() {
    
        super();
        callList = new ArrayList();
    }

    public String[] getCalls() {
        
        return (String[]) callList.toArray(new String[callList.size()]);
    }

    public void startDocument() {

        callList.add("startDocument");
    }

    public void startRecord() {

        callList.add("startRecord");
    }

    public void startValue() {

        callList.add("startValue");
    }

    public void character(char ch) {

        callList.add("character:" + ch);
    }

    public void endValue() {

        callList.add("endValue");
    }

    public void endRecord() {

        callList.add("endRecord");
    }

    public void endDocument() {

        callList.add("endDocument");
    }
}
