package jp.sourceforge.csvparser;

import junit.framework.TestCase;

public class CSVHandlerImplTest extends TestCase {

    private CSVHandlerImpl handler;

    public CSVHandlerImplTest(String name) {

        super(name);
    }

    protected void setUp() throws Exception {

        super.setUp();
        handler = new CSVHandlerImpl();
    }

    private void assertEquals(String[][] expected, String[][] actual) {

        assertEquals(expected.length, actual.length);

        for (int i = 0; i < expected.length; i++) {
            assertEquals(String.valueOf(i), expected[i].length,
                    actual[i].length);

            for (int j = 0; j < expected[i].length; j++) {
                assertEquals(String.valueOf(i) + "." + String.valueOf(j),
                        expected[i][j], actual[i][j]);
            }
        }
    }

    public void testToRecordsEmptyDocument() throws Exception {

        handler.startDocument();
        handler.endDocument();
        String[][] actual = handler.toRecords();
        String[][] expected = {};
        assertEquals(expected, actual);
    }

    public void testToRecordsEmptyRecord() throws Exception {

        handler.startDocument();
        handler.startRecord();
        handler.endRecord();
        handler.endDocument();
        String[][] actual = handler.toRecords();
        String[][] expected = { {} };
        assertEquals(expected, actual);
    }

    public void testToRecordsEmptyValue() throws Exception {

        handler.startDocument();
        handler.startRecord();
        handler.startValue();
        handler.endValue();
        handler.endRecord();
        handler.endDocument();
        String[][] actual = handler.toRecords();
        String[][] expected = { { "" } };
        assertEquals(expected, actual);
    }
}