package jp.sourceforge.csvparser;

import java.util.ArrayList;
import java.util.List;

public class CSVHandlerImpl implements CSVHandler {

    private List recordList;

    private List valueList;

    private StringBuffer valueBuffer;

    public void startDocument() {

        recordList = new ArrayList();
    }

    public void startRecord() {

        valueList = new ArrayList();
    }

    public void startValue() {

        valueBuffer = new StringBuffer();
    }

    public void character(char ch) {

        valueBuffer.append(ch);
    }

    public void endValue() {

        valueList.add(valueBuffer.toString());
    }

    public void endRecord() {

        recordList.add(valueList.toArray(new String[valueList.size()]));
    }

    public void endDocument() {

        /* ignore */
    }

    public String[][] toRecords() {

        return (String[][]) recordList.toArray(new String[recordList.size()][]);
    }
}