/*
 * Decompiled with CFR 0.152.
 */
package egeyama.jsf.validator;

import egeyama.jsf.util.FacesUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DateValidator
implements Validator {
    public static final String MESSAGE_ID = "egeyama.jsf.INVALID_DATE";

    public void validate(FacesContext context, UIComponent uiComponent, Object value) {
        if (context == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        String inputValue = (String)value;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            Date date = sdf.parse(inputValue);
            if (!inputValue.equals(sdf.format(date))) {
                throw new RuntimeException("\u65e5\u4ed8\u304c\u6b63\u3057\u304f\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            }
        }
        catch (Exception e) {
            UIInput input = (UIInput)uiComponent;
            input.setValid(false);
            String targetId = input.getId();
            String label = FacesUtils.findLabel(context, targetId);
            if (label == null) {
                label = targetId;
            }
            ResourceBundle bundle = ResourceBundle.getBundle("egeyama.jsf.validator.Messages");
            String message = MessageFormat.format(bundle.getString(MESSAGE_ID), label);
            throw new ValidatorException(new FacesMessage(message, ""));
        }
    }
}

