(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobO.
 *
 * ÍobO is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobO is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
program cb;

{$APPTYPE CONSOLE}

uses
  SysUtils, Classes, gcryptUnit, KeyUnit;

procedure GenNewKey;
var
  O1, O2: TFileStream;
  SecKey: TSecKey;
begin
  Writeln('* GenNewKey: Start');
  SecKey := TSecKey.Create;
  try
    SecKey.GenNewKey(1024, 'Kikuchi Jun <kikuchi@bonnou.com>', 'hogehoge');

    O1 := TFileStream.Create('d:\seckey', fmCreate);
    try
      SecKey.SaveToStream(O1);
    finally
      O1.Free;
    end;

    O2 := TFileStream.Create('d:\pubkey', fmCreate);
    try
      SecKey.SavePubKeyToStream(O2);
    finally
      O2.Free;
    end;
  finally
    SecKey.Free;
  end;
  Writeln('* GenNewKey: Done');
  Writeln('');
end;

procedure LoadSecKey;
var
  O: TFileStream;
  SecKey: TSecKey;
begin
  Writeln('* LoadSecKey: Start');
  SecKey := TSecKey.Create;
  try
    O := TFileStream.Create('d:\seckey', fmOpenRead);
    try
      SecKey.LoadFromStream(O);
      WriteLn('UnLock wrong key: ', SecKey.Unlock('hogehoge1'));
      WriteLn('CheckKey: ', SecKey.CheckKey);
      WriteLn('UnLock right key: ', SecKey.Unlock('hogehoge'));
      WriteLn('CheckKey: ', SecKey.CheckKey);
      WriteLn('Lock: ', SecKey.Lock('hogehoge'));
    finally
      O.Free;
    end;
  finally
    SecKey.Free;
  end;
  Writeln('* LoadSecKey: Done');
  Writeln('');
end;

procedure LoadPubKey;
var
  O: TFileStream;
  PubKey: TPubKey;
begin
  Writeln('* LoadPubKey: Start');
  PubKey := TPubKey.Create;
  try
    O := TFileStream.Create('d:\pubkey', fmOpenRead);
    try
      PubKey.LoadFromStream(O);
      WriteLn('CheckKey: ', PubKey.CheckKey);
    finally
      O.Free;
    end;
  finally
    PubKey.Free;
  end;
  Writeln('* LoadPubKey: Done');
  Writeln('');
end;

procedure Encrypt;
var
  I, O: TFileStream;
  PubKey: TPubKey;
  LH: TLiteralPacketHeader;
begin
  Writeln('* Encrypt: Start');
  Writeln(' Load PubKey');
  PubKey := TPubKey.Create;
  try
    O := TFileStream.Create('d:\pubkey', fmOpenRead);
    try
      PubKey.LoadFromStream(O);
      WriteLn('CheckKey: ', PubKey.CheckKey);
    finally
      O.Free;
    end;

    I := TFileStream.Create('d:input', fmOpenRead);
    try
      O := TFileStream.Create('d:\encrypt', fmCreate);
      try
        LH := TLiteralPacketHeader.Create;
        try
//          LH.Mode := FILE_MODE_BIN;
//          LH.FileName := 'hogefile';
          LH.Mode := FILE_MODE_TEXT;
          LH.FileName := '_CONSOLE';
          LH.Date := Now;
          
          Writeln(' Encrypt File');
          PubKey.EncodeFile(I, O, LH);
        finally
          LH.Free;
        end;
      finally
        O.Free;
      end;
    finally
      I.Free;
    end;
  finally
    PubKey.Free;
  end;
  Writeln('* Encrypt: Done');
  Writeln('');
end;

procedure Decrypt;
var
  I, O: TFileStream;
  SecKey: TSecKey;
  LH: TLiteralPacketHeader;
begin
  Writeln('* Decrypt: Start');
  SecKey := TSecKey.Create;
  try
    O := TFileStream.Create('d:\seckey', fmOpenRead);
    try
      SecKey.LoadFromStream(O);
      WriteLn('UnLock right key: ', SecKey.Unlock('hogehoge'));
      WriteLn('CheckKey: ', SecKey.CheckKey);
    finally
      O.Free;
    end;

    I := TFileStream.Create('d:encrypt', fmOpenRead);
    try
      LH := TLiteralPacketHeader.Create;
      try
        Writeln(' Decrypt FileHeader');
        SecKey.DecodeFileHeader(I, LH);
        writeln(' FileHeader:');
        writeln(' FileName: ', LH.FileName);
        writeln(' Date: ', DateTimeToStr(LH.Date));
        writeln(' Mode ', Char(LH.Mode));
      finally
        LH.Free;
      end;
    finally
      I.Free;
    end;

    I := TFileStream.Create('d:encrypt', fmOpenRead);
    try
      O := TFileStream.Create('d:\decrypt', fmCreate);
      try
        LH := TLiteralPacketHeader.Create;
        try
          Writeln(' Decrypt File');
          SecKey.DecodeFile(I, O, LH);
        finally
          LH.Free;
        end;
      finally
        O.Free;
      end;
    finally
      I.Free;
    end;
  finally
    SecKey.Free;
  end;
  Writeln('* Decrypt: Done');
  Writeln('');
end;

var
  S: string;
begin
  { TODO -oUser -cConsole Main : ̉ɃR[hLqĂ }
  gcry_control(GCRYCTL_INIT_SECMEM, 16384, 0);

//  GenNewKey;
//  LoadSecKey;
//  LoadPubKey;
  Encrypt;
  Decrypt;
  
  Readln(S);
end.
