(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobN.
 *
 * ÍobN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit UTCUnit;

interface

uses
  Windows, SysUtils;

function UTCToDateTime(UTC: Longword): TDateTime;
function DateTimeToUTC(D: TDateTime): Longword;

implementation

function GetOffsetFromUTC: Cardinal;
var
  TZ: TTimeZoneInformation;
  RC: Longword;
begin
  RC := GetTimeZoneInformation(TZ);
  Assert(RC <> $FFFFFFFF);
  Result := TZ.Bias * 60 * -1;
end;

function UTCToDateTime(UTC: Longword): TDateTime;
begin
  UTC := UTC + GetOffsetFromUTC;
  Result := EncodeDate(1970, 1, 1) + (UTC / 86400);
end;

function DateTimeToUTC(D: TDateTime): Longword;
var
  UTC: Longword;
  Offset: Cardinal;
begin
  UTC := Round((D - EncodeDate(1970, 1, 1)) * 86400);
  Offset := GetOffsetFromUTC;
  if Offset > 0 then
    Result := UTC - Offset
  else
    Result := UTC + Offset;
end;

end.
