(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobN.
 *
 * ÍobN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit GenKeyThreadUnit;

interface

uses
  Classes, SysUtils;

type
  TGenKeyThread = class(TThread)
  private
    { Private 錾 }
    FFileName,
    FUserID,
    FPasswd: string;
  protected
    procedure Execute; override;
  public
    constructor Create(FileName, UserID, Passwd: string; CreateSuspended: Boolean);
  end;

implementation

uses
  Dialogs, gcryptUnit, KeyUnit;

{: 
  قȂXbhL VCL ܂ CLX ̃\bh/֐/
  vpeBʂ̃Xbh̒爵ꍇAr̖肪
  ܂B

  CXbh̏LIuWFNgɑ΂Ă Synchronize
  \bhgł܂B̃IuWFNgQƂ邽
  ̃\bhXbhNXɒǉASynchronize \bh
  Ƃēn܂B

  Ƃ΁AUpdateCaption \bhȉ̂悤ɒ`A

    procedure TGenKeyThread.UpdateCaption;
    begin
      Form1.Caption := 'TGenKeyThread Xbh珑܂';
    end;

  Execute \bh̒ Synchronize \bhɓnƂŃC
  XbhL Form1  Caption vpeBSɕ
  Xł܂B

      Synchronize(UpdateCaption);
}

{ TGenKeyThread }

procedure TGenKeyThread.Execute;
var
  O: TFileStream;
  SecKey: TSecKey;
begin
  { ToDo : XbhƂĎsR[h̉ɋLqĂ }
  SecKey := TSecKey.Create;
  try
    SecKey.GenNewKey(1024, FUserID, FPasswd);

    O := TFileStream.Create(FFileName + '.bag', fmCreate or fmShareExclusive);
    try
      SecKey.SavePubKeyToStream(O);
    finally
      O.Free;
    end;

    O := TFileStream.Create(FFileName + '.key', fmCreate or fmShareExclusive);
    try
      SecKey.SaveToStream(O);
    finally
      O.Free;
    end;
  finally
    SecKey.Free;
  end;
end;

constructor TGenKeyThread.Create(FileName, UserID, Passwd: string; CreateSuspended: Boolean);
begin
  inherited Create(CreateSuspended);

  FFileName  := FileName;
  FUserID    := UserID;
  FPasswd    := Passwd;

  gcry_control(GCRYCTL_INIT_SECMEM, 16384, 0);
end;

end.
