package yukihane.inqubus.config;

import org.apache.commons.lang.builder.ToStringBuilder;
import saccubus.worker.profile.LoginProfile;

/**
 * コンフィグに設定された値を基にしたLoginProfile実装.
 * @author yuki
 */
public class ConfigLoginProfile implements LoginProfile {

    private final String mail;
    private final String password;

    public ConfigLoginProfile() {
        final Config p = Config.INSTANCE;
        this.mail = p.getId();
        this.password = p.getPassword();
    }

    @Override
    public String getMail() {
        return this.mail;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
