package yukihane.inqubus.saccubus.prompt;

import saccubus.worker.profile.CommentProfile;
import saccubus.worker.profile.LoginProfile;
import yukihane.inqubus.config.ConfigCommentProfile;
import yukihane.inqubus.config.ConfigDownloadProfile;

/**
 * さきゅばすのコマンドプロンプト仕様にあわせるためのDownloadProfile実装
 * @author yuki
 */
class DownloadProfileImpl extends ConfigDownloadProfile {

    private final LoginProfile loginProfile;
    private final CommentProfile commentProfile;

    DownloadProfileImpl(final String mail, final String pass, final long time) {
        this.loginProfile = new LoginProfile() {

            @Override
            public String getMail() {
                return mail;
            }

            @Override
            public String getPassword() {
                return pass;
            }
        };

        this.commentProfile = new ConfigCommentProfile() {

            @Override
            public long getBackLogPoint() {
                return time;
            }
        };
    }

    @Override
    public LoginProfile getLoginProfile() {
        return loginProfile;
    }

    @Override
    public CommentProfile getCommentProfile() {
        return this.commentProfile;
    }
}
