/*
 * Decompiled with CFR 0.152.
 */
package yukihane.mediainfowrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yukihane.mediainfowrapper.Info;
import yukihane.mediainfowrapper.Size;

public class MediaInfo {
    public static Info getInfo(File mediaInfoBin, File videoFile) throws IOException {
        String line;
        String[] command = new String[]{mediaInfoBin.getPath(), videoFile.getPath()};
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Pattern widthPattern = Pattern.compile("Width +:(.+)pixels");
        Pattern heightPattern = Pattern.compile("Height +:(.+)pixels");
        int width = -1;
        int height = -1;
        while ((line = reader.readLine()) != null) {
            Matcher widthMatcher = widthPattern.matcher(line);
            if (widthMatcher.find()) {
                String str = widthMatcher.group(1).replaceAll(" ", "");
                width = Integer.parseInt(str);
                continue;
            }
            Matcher heightMatcher = heightPattern.matcher(line);
            if (!heightMatcher.find()) continue;
            String str = heightMatcher.group(1).replaceAll(" ", "");
            height = Integer.parseInt(str);
        }
        return new Info(width, height);
    }

    public static Size adjustSize(Info info, int maxWidth, int maxHeight) {
        double heightRatio;
        int nowWidth = info.getWidth();
        int nowHeight = info.getHeight();
        if (nowWidth <= maxWidth && nowHeight <= maxHeight) {
            return new Size(nowWidth, nowHeight);
        }
        double widthRatio = MediaInfo.calcRatio(nowWidth, maxWidth);
        if (widthRatio >= (heightRatio = MediaInfo.calcRatio(nowHeight, maxHeight))) {
            int adjustedWidth = MediaInfo.adjust(nowWidth, widthRatio);
            int adjustedHeight = MediaInfo.adjust(nowHeight, widthRatio);
            return new Size(adjustedWidth, adjustedHeight);
        }
        int adjustedWidth = MediaInfo.adjust(nowWidth, heightRatio);
        int adjustedHeight = MediaInfo.adjust(nowHeight, heightRatio);
        return new Size(adjustedWidth, adjustedHeight);
    }

    private static double calcRatio(int now, int max) {
        return (double)now / (double)max;
    }

    private static int adjust(int size, double ratio) {
        return (int)((double)size / ratio);
    }
}

