/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package saccubus.net;

/**
 *
 * @author yuki
 */
public class VideoInfo {

    private final String videoTitle;
    private final String threadId;
    private final String videoUrl;
    private final String msgUrl;
    private final String userId;
    private final int videoLength;
    private final OfficialOption officialOption;

    /**
     *
     * @param videoTitle
     * @param threadId
     * @param videoUrl
     * @param msgUrl
     * @param userId
     * @param videoLength
     * @param officialOption null.
     */
    VideoInfo(String videoTitle, String threadId, String videoUrl, String msgUrl, String userId, int videoLength,
            OfficialOption officialOption) {
        if (videoTitle == null || threadId == null || videoUrl == null || msgUrl == null || userId == null) {
            throw new IllegalArgumentException("video information̏񂪕słB");
        }
        this.videoTitle = videoTitle;
        this.threadId = threadId;
        this.videoUrl = videoUrl;
        this.msgUrl = msgUrl;
        this.userId = userId;
        this.videoLength = videoLength;
        this.officialOption = officialOption;
    }

    public String getMsgUrl() {
        return msgUrl;
    }

    public String getThreadId() {
        return threadId;
    }

    public String getUserId() {
        return userId;
    }

    public int getVideoLength() {
        return videoLength;
    }

    public String getVideoTitle() {
        return videoTitle;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public OfficialOption getOfficialOption() {
        return officialOption;
    }

    public static class OfficialOption {

        private final String threadKey;
        private final String force184;

        public OfficialOption(String threadKey, String force184) {
            if (threadKey == null || force184 == null) {
                throw new IllegalArgumentException("pL[sł");
            }
            this.threadKey = threadKey;
            this.force184 = force184;
        }

        public String getThreadKey() {
            return threadKey;
        }

        public String getForce184() {
            return force184;
        }
    }
}
