/* $Id: FfmpegOption.java 297 2009-12-18 06:39:33Z yuki $ */
package saccubus.converter.profile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

/**
 *
 * @author yuki
 */
public class FfmpegOption {

    private final String extOption;
    private final String inOption;
    private final String outOption;
    private final String mainOption;

    public static FfmpegOption load(File file) throws IOException {
        Properties prop = new Properties();
        prop.loadFromXML(new FileInputStream(file));
        String ext = prop.getProperty("EXT");
        String in = prop.getProperty("IN");
        String out = prop.getProperty("OUT");
        String main = prop.getProperty("MAIN");
        if (ext == null || in == null || out == null || main == null) {
            throw new IOException("ϊIvVt@CB");
        }
        return new FfmpegOption(ext, main, in, out);
    }

    public FfmpegOption(String extOption, String mainOption, String inOption, String outOption) {
        this.extOption = (extOption.startsWith(".")) ? extOption : "." + extOption;
        this.inOption = inOption;
        this.outOption = outOption;
        this.mainOption = mainOption;
    }

    public String getExtOption() {
        return extOption;
    }

    public String getInOption() {
        return inOption;
    }

    public String getMainOption() {
        return mainOption;
    }

    public String getOutOption() {
        return outOption;
    }
}
