/* $Id: FileLocator.java 247 2009-12-15 09:00:12Z yuki $ */
package saccubus.converter.filegetter;

import java.io.File;
import java.io.FilenameFilter;

/**
 *
 * @author yuki
 */
class FileLocator {

    private final boolean autoFileName;
    private final File initFile;
    private final String prefix;
    private final String title;
    private final String suffix;

    FileLocator(boolean autoFileName, File initFile, String prefix, String title, String suffix) {
        this.autoFileName = autoFileName;
        this.initFile = initFile;
        this.prefix = prefix;
        this.title = title;
        this.suffix = suffix;
    }

    /**
     * RXgN^Ŏw肵Ńt@CB
     * autoFileNamefalsȅꍇAږOwł邽ߎw肳ꂽt@Ĉ܂ܕԂB
     * autoFileNametruȅꍇAinitFilefBNgprefixŎn܂t@C݂邩
     * ΂ԂB
     * ̃t@CꍇAw肳ꂽp[^ɏ]t@CԂB
     * @return ]̃t@CBt@C݂͑ꍇA݂Ȃꍇ邱ƂɒӁB
     */
    File getFile() {
        if (!isAutoNaming()) {
            return initFile;
        } else {
            File res = searchFile();
            if (res != null) {
                return res;
            }
            return new File(initFile, prefix + title + suffix);
        }
    }

    private final File searchFile() {
        FilenameFilter filter = new FilenameFilter() {

            public boolean accept(File dir, String name) {
                return (name.startsWith(prefix)) ? true : false;
            }
        };
        File[] res = initFile.listFiles(filter);
        if (res == null || res.length == 0) {
            return null;
        }
        return res[0];
    }

    protected boolean isAutoNaming() {
        return autoFileName;
    }

    protected final boolean getAutoFileName() {
        return autoFileName;
    }
}
