/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package saccubus.converter.filegetter;

import java.io.File;
import java.io.IOException;
import saccubus.net.NicoClient;
import saccubus.net.TextProgressListener;
import saccubus.net.VideoInfo;

/**
 *
 * @author yuki
 */
public class CommentFileWebGetter extends TcommFileWebGetter {

    private final boolean autoCommentNum;
    private final int backComment;

    CommentFileWebGetter(NicoClient client, VideoInfo vi, boolean autoCommentNum, int backComment) {
        super(client, vi);
        this.autoCommentNum = autoCommentNum;
        this.backComment = backComment;
    }

    @Override
    public File get(File file, TextProgressListener listener) throws IOException {
        String com = Integer.toString(backComment);
        if (this.autoCommentNum) {
            com = getClient().getBackCommentFromLength(getVideoInfo(), com);
        }

        File res = getClient().getComment(getVideoInfo(), file, listener, com);
        if (res == null) {
            throw new IOException("Rgt@C̃_E[hɎs܂B");
        }
        return res;
    }
}
