package yukihane.coroid

import java.util.regex.Matcher
import java.util.regex.Pattern
import saccubus.net.TextProgressListener

private class SaccubusListener implements TextProgressListener{
    private final id
    private final int total
    private static final Pattern pattern = Pattern.compile('time=(.*?) ')
    
    SaccubusListener(id, String length){
        this.id = id
        def times = length.split(':')
        total = Integer.parseInt(times[0]) * 60 + Integer.parseInt(times[1])
    }

    void setText(String text) {
        Matcher matcher = pattern.matcher(text)
        // 時間表示がある出力であれば, 進捗を求め永続化する
        if(matcher.find()){
            def current = Double.parseDouble(matcher.group(1))
            int progress = 100 * current / total
            TranscodeStatusHolder.map().put(id.toString(), 'C'+progress)
        }
    }
}