package yukihane.coroid

import org.cyberneko.html.parsers.SAXParser
import static yukihane.coroid.NicoVideoConst.*
import nicobrowser.search.*

class TopController {

    def index = {
        def rankHtml = new XmlSlurper(new SAXParser()).parse(RANKING_URL)

        def groups = rankHtml.'BODY'.'DIV'.'DIV'.'DIV'.'TABLE'.'TBODY'.'TR'.'TD'.'TABLE'.'TBODY'.'TR'.'TH'.'A'
        def groupMap = [:]
        groups.each{groupMap[it.text()] = it.@href.toString().split('/')[6]}
        // groupMap.each{println it.key + ', ' + it.value}

        def categoryMap = ['all':'カテゴリ合算']
        for(group in groupMap){
            def groupUrl = RANKING_URL + 'fav/daily/' + group.value
            def groupHtml = new XmlSlurper(new SAXParser()).parse(groupUrl)
            def categories = groupHtml.'*'.'*'.'*'.'*'.'*'.'*'.'*'.'TABLE'.'TBODY'.'TR'.'TD'.'NOBR'.'A'
            categories.each{categoryMap[it.@href.toString().split('/')[6]]=it.'DIV'.text()}
        }
        [categories:categoryMap, kinds:KINDS, spans:SPANS,
            searchKinds:SearchKind.values(), sortKinds:SortKind.values(), sortOrders:SortOrder.values()]
    }

    def submit = {
        def c = params.category.split(':')
        params.category = c[0]
        params.categoryTitle = c[1]

        def p = [:]
        switch (params.pageType) {
        case 'ranking':
            redirect(controller:'nicoContent', action:'ranking', params:params)
            break
        case 'search':
            p += ['word':params.searchWord]
            p += ['kind':params.searchKind]
            p += ['sort':params.sortKind]
            p += ['order':params.sortOrder]
            redirect(controller:'nicoContent', action:'search', params:p)
            break
        case 'history':
            redirect(controller:'nicoContent', action:'history')
            break
        default:
            redirect(controller:'nicoContent', action:'mylist')
        }
    }
}
