// locations to search for config files that get merged into the main config
// config files can either be Java properties files or ConfigSlurper scripts

// grails.config.locations = [ "classpath:${appName}-config.properties",
//                             "classpath:${appName}-config.groovy",
//                             "file:${userHome}/.grails/${appName}-config.properties",
//                             "file:${userHome}/.grails/${appName}-config.groovy"]

// if(System.properties["${appName}.config.location"]) {
//    grails.config.locations << "file:" + System.properties["${appName}.config.location"]
// }
grails.mime.file.extensions = true // enables the parsing of file extensions from URLs into the request format
grails.mime.use.accept.header = false
grails.mime.types = [ html: ['text/html','application/xhtml+xml'],
                      xml: ['text/xml', 'application/xml'],
                      text: 'text/plain',
                      js: 'text/javascript',
                      rss: 'application/rss+xml',
                      atom: 'application/atom+xml',
                      css: 'text/css',
                      csv: 'text/csv',
                      all: '*/*',
                      json: ['application/json','text/json'],
                      form: 'application/x-www-form-urlencoded',
                      multipartForm: 'multipart/form-data'
                    ]
// The default codec used to encode data with ${}
grails.views.default.codec="none" // none, html, base64
grails.views.gsp.encoding="UTF-8"
grails.converters.encoding="UTF-8"
// enable Sitemesh preprocessing of GSP pages
grails.views.gsp.sitemesh.preprocess = true
// scaffolding templates configuration
grails.scaffolding.templates.domainSuffix = 'Instance'

// Set to false to use the new Grails 1.2 JSONBuilder in the render method
grails.json.legacy.builder=false
// enabled native2ascii conversion of i18n properties files
grails.enable.native2ascii = true
// whether to install the java.util.logging bridge for sl4j. Disable fo AppEngine!
grails.logging.jul.usebridge = true
// packages to include in Spring bean scanning
grails.spring.bean.packages = []

grails.views.javascript.library="jquery"

// set per-environment serverURL stem for creating absolute links
environments {
    production {
        grails.serverURL = "http://www.changeme.com"
    }
    development {
        grails.serverURL = "http://localhost:8080/${appName}"
    }
    test {
        grails.serverURL = "http://localhost:8080/${appName}"
    }

}

// log4j configuration
log4j = {
    // Example of changing the log pattern for the default console
    // appender:
    //
    //appenders {
    //    console name:'stdout', layout:pattern(conversionPattern: '%c{2} %m%n')
    //}


    error  'org.codehaus.groovy.grails.web.servlet',  //  controllers
	       'org.codehaus.groovy.grails.web.pages', //  GSP
	       'org.codehaus.groovy.grails.web.sitemesh', //  layouts
	       'org.codehaus.groovy.grails.web.mapping.filter', // URL mapping
	       'org.codehaus.groovy.grails.web.mapping', // URL mapping
	       'org.codehaus.groovy.grails.commons', // core / classloading
	       'org.codehaus.groovy.grails.plugins', // plugins
	       'org.codehaus.groovy.grails.orm.hibernate', // hibernate integration
	       'org.springframework',
	       'org.hibernate',
           'net.sf.ehcache.hibernate'

    warn   'org.mortbay.log'
}

// Added by the Spring Security Core plugin:
grails.plugins.springsecurity.userLookup.userDomainClassName = 'yukihane.coroid.User'
grails.plugins.springsecurity.userLookup.authorityJoinClassName = 'yukihane.coroid.UserRole'
grails.plugins.springsecurity.authority.className = 'yukihane.coroid.Role'

grails.plugins.springsecurity.rejectIfNoRule = true
grails.plugins.springsecurity.securityConfigType = grails.plugins.springsecurity.SecurityConfigType.InterceptUrlMap

grails.plugins.springsecurity.interceptUrlMap = [
   '/js/**':        ['IS_AUTHENTICATED_ANONYMOUSLY'],
   '/css/**':       ['IS_AUTHENTICATED_ANONYMOUSLY'],
   '/images/**':    ['IS_AUTHENTICATED_ANONYMOUSLY'],
   '/login/**':     ['IS_AUTHENTICATED_ANONYMOUSLY'],
   '/logout/**':    ['IS_AUTHENTICATED_ANONYMOUSLY'],
   '/temp/**':      ['IS_AUTHENTICATED_ANONYMOUSLY'],
   '/**':           ['ROLE_USER']
]

// === EDIT BELOW ===
coroid.saccubus.mail = 'your@mail.address'
coroid.saccubus.password = 'your_password'
coroid.mylist = '12345' // your public mylist no.
coroid.externallink = true

coroid.user.id = coroid.saccubus.mail // coroid login ID, is *NOT*  for nicovideo
coroid.user.password = coroid.saccubus.password // coroid login password, is *NOT* for nicovideo

coroid.mp4box = 'bin/MP4Box'
coroid.mediainfo = 'bin/mediainfo'
coroid.ffmpeg.option = '-vcodec libx264 -g 150 -qmin 10 -qmax 51 -qdiff 4 -me_method umh -subq 6 -me_range 16 -trellis 1 -refs 3 -b 256k -bt 256k -ab 64k -bufsize 512k -maxrate 512k -partitions +parti4x4+partp8x8+partb8x8 -flags +loop -flags2 +mixed_refs -cmp +chroma -keyint_min 25 -sc_threshold 40 -i_qfactor 0.71 -coder 0 -level 21'
coroid.display.width = 480
coroid.display.height = 320

grails.plugins.springsecurity.auth.forceHttps = true
grails.plugins.springsecurity.portMapper.httpPort = 8080  // should synchronize command-line parameter
grails.plugins.springsecurity.portMapper.httpsPort = 8443 // should synchronize command-line parameter
