/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.v1;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import jp.cssj.driver.ctip.common.ChannelIO;
import jp.cssj.driver.ctip.v1.V1Session;

public class V1RequestConsumer {
    public static final byte PROPERTY = 1;
    public static final byte RESOURCE = 2;
    public static final byte MAIN = 3;
    public static final byte DATA = 4;
    public static final byte END = 5;
    private final String encoding;
    private final byte[] buff = new byte[1029];
    private final ChannelIO io;
    private int pos = 0;
    private V1Session session;

    V1RequestConsumer(ChannelIO io, String encoding) throws IOException {
        this.io = io;
        this.encoding = encoding;
    }

    public void property(String name, String value) throws IOException {
        this.flush();
        if (name.equals("input.exclude")) {
            name = "ctip.exclude";
        } else if (name.equals("input.include")) {
            name = "ctip.include";
        }
        byte[] nameBytes = ChannelIO.toBytes(name, this.encoding);
        byte[] valueBytes = ChannelIO.toBytes(value, this.encoding);
        ByteBuffer src = ByteBuffer.allocate(nameBytes.length + valueBytes.length + 9);
        src.putInt(nameBytes.length + valueBytes.length + 5);
        src.put((byte)1);
        src.putShort((short)nameBytes.length);
        src.put(nameBytes);
        src.putShort((short)valueBytes.length);
        src.put(valueBytes);
        this.io.writeAll(src);
    }

    public void resource(URI uri, String mimeType, String encoding) throws IOException {
        this.flush();
        byte[] uriBytes = ChannelIO.toBytes(uri.toString(), this.encoding);
        byte[] mimeTypeBytes = ChannelIO.toBytes(mimeType, this.encoding);
        byte[] encodingBytes = ChannelIO.toBytes(encoding, this.encoding);
        ByteBuffer src = ByteBuffer.allocate(uriBytes.length + mimeTypeBytes.length + encodingBytes.length + 11);
        src.putInt(uriBytes.length + mimeTypeBytes.length + encodingBytes.length + 7);
        src.put((byte)2);
        src.putShort((short)uriBytes.length);
        src.put(uriBytes);
        src.putShort((short)mimeTypeBytes.length);
        src.put(mimeTypeBytes);
        src.putShort((short)encodingBytes.length);
        src.put(encodingBytes);
        this.io.writeAll(src);
    }

    public void main(URI uri, String mimeType, String encoding) throws IOException {
        this.flush();
        byte[] uriBytes = ChannelIO.toBytes(uri.toString(), this.encoding);
        byte[] mimeTypeBytes = ChannelIO.toBytes(mimeType, this.encoding);
        byte[] encodingBytes = ChannelIO.toBytes(encoding, this.encoding);
        ByteBuffer src = ByteBuffer.allocate(uriBytes.length + mimeTypeBytes.length + encodingBytes.length + 11);
        src.putInt(uriBytes.length + mimeTypeBytes.length + encodingBytes.length + 7);
        src.put((byte)3);
        src.putShort((short)uriBytes.length);
        src.put(uriBytes);
        src.putShort((short)mimeTypeBytes.length);
        src.put(mimeTypeBytes);
        src.putShort((short)encodingBytes.length);
        src.put(encodingBytes);
        this.io.writeAll(src);
    }

    protected void setCTIPSession(V1Session session) {
        this.session = session;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[i + off]);
        }
    }

    private void write(int b) throws IOException {
        if (this.pos >= 1024) {
            this.flush();
        }
        this.buff[this.pos++ + 5] = (byte)b;
    }

    private void flush() throws IOException {
        if (this.pos > 0) {
            int payload = this.pos + 1;
            ByteBuffer src = ByteBuffer.wrap(this.buff, 0, this.pos + 5);
            src.putInt(payload);
            src.put((byte)4);
            src.position(0);
            do {
                SelectionKey key = this.io.rwselect();
                if (src.remaining() > 0 && key.isWritable()) {
                    this.io.getChannel().write(src);
                }
                if (!key.isReadable()) continue;
                this.session.buildNext();
            } while (src.remaining() > 0);
            this.pos = 0;
        }
    }

    public void end() throws IOException {
        this.flush();
        ByteBuffer src = ByteBuffer.allocate(4);
        src.putInt(0);
        this.io.writeAll(src);
    }
}

