/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.v2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;
import jp.cssj.driver.ctip.common.ChannelIO;
import jp.cssj.driver.ctip.v2.V2RequestConsumer;
import jp.cssj.resolver.helpers.URIHelper;

public class V2ContentProducer {
    protected final String charset;
    protected final URI serverURI;
    protected ChannelIO io;
    private byte type;
    private byte mode;
    private int blockId;
    private int anchorId;
    private long length;
    private short code;
    private URI uri;
    private String mimeType;
    private String message;
    private String encoding;
    private List<String> args = new ArrayList<String>();
    private ByteBuffer data;
    private ByteBuffer destLong = ByteBuffer.allocate(8);
    private ByteBuffer destInt = ByteBuffer.allocate(4);
    private ByteBuffer destShort = ByteBuffer.allocate(2);
    private ByteBuffer destByte = ByteBuffer.allocate(1);

    public V2ContentProducer(URI uri, String encoding) throws IOException {
        this.charset = encoding;
        this.serverURI = uri;
    }

    public V2RequestConsumer connect(String user, String password) throws IOException {
        String host = this.serverURI.getHost();
        int port = this.serverURI.getPort();
        if (port == -1) {
            port = 8099;
        }
        long timeout = 0L;
        String query = this.serverURI.getQuery();
        if (query != null) {
            String[] params = query.split("&");
            for (int i = 0; i < params.length; ++i) {
                if (!params[0].startsWith("timeout=")) continue;
                timeout = Long.parseLong(params[0].substring(8));
            }
        }
        InetSocketAddress address = new InetSocketAddress(host, port);
        ByteChannel channel = this.createChannel(address);
        this.io = new ChannelIO(channel, timeout);
        byte[] header = ("CTIP/2.0 " + this.charset + "\n").getBytes("ISO-8859-1");
        this.io.writeAll(ByteBuffer.wrap(header));
        String message = "PLAIN: " + user + " " + password + "\n";
        byte[] data = message.getBytes(this.charset);
        ByteBuffer src = ByteBuffer.allocate(data.length);
        src.put(data);
        this.io.writeAll(src);
        data = this.io.readBytes(4);
        String response = new String(data, this.charset);
        if (response.equals("NG \n")) {
            throw new SecurityException("\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        if (!response.equals("OK \n")) {
            throw new IOException("\u4e0d\u6b63\u306a\u30ec\u30b9\u30dd\u30f3\u30b9\u3067\u3059:" + response);
        }
        return new V2RequestConsumer(this.io, this.charset);
    }

    protected ByteChannel createChannel(InetSocketAddress address) throws IOException {
        SocketChannel socketChannel = SelectorProvider.provider().openSocketChannel();
        socketChannel.connect(address);
        socketChannel.configureBlocking(false);
        return socketChannel;
    }

    protected void close() throws IOException {
        if (this.io != null) {
            this.io.close();
            this.io = null;
        }
    }

    public void next() throws IOException {
        int payload = this.io.readInt(this.destInt);
        this.type = this.io.readByte(this.destByte);
        switch (this.type) {
            case 1: {
                try {
                    this.uri = URIHelper.create(this.charset, this.io.readString(this.destShort, this.charset));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage());
                }
                this.mimeType = this.io.readString(this.destShort, this.charset);
                this.encoding = this.io.readString(this.destShort, this.charset);
                this.length = this.io.readLong(this.destLong);
                break;
            }
            case 17: {
                this.blockId = this.io.readInt(this.destInt);
                this.data = ByteBuffer.allocate(payload -= 5);
                this.io.readAll(this.data);
                this.data.position(0);
                break;
            }
            case 18: {
                break;
            }
            case 19: 
            case 24: {
                this.anchorId = this.io.readInt(this.destInt);
                break;
            }
            case 20: {
                this.code = this.io.readShort(this.destShort);
                payload -= 3;
                short len = this.io.readShort(this.destShort);
                byte[] buff = new byte[len];
                ByteBuffer dest = ByteBuffer.wrap(buff);
                this.io.readAll(dest);
                this.message = new String(buff, this.charset);
                payload -= 2 + len;
                this.args.clear();
                while (payload > 0) {
                    len = this.io.readShort(this.destShort);
                    buff = new byte[len];
                    dest = ByteBuffer.wrap(buff);
                    this.io.readAll(dest);
                    String arg = new String(buff, this.charset);
                    this.args.add(arg);
                    payload -= 2 + len;
                }
                break;
            }
            case 50: {
                this.mode = this.io.readByte(this.destByte);
                this.code = this.io.readShort(this.destShort);
                payload -= 4;
                short len = this.io.readShort(this.destShort);
                byte[] buff = new byte[len];
                ByteBuffer dest = ByteBuffer.wrap(buff);
                this.io.readAll(dest);
                this.message = new String(buff, this.charset);
                payload -= 2 + len;
                while (payload > 0) {
                    len = this.io.readShort(this.destShort);
                    buff = new byte[len];
                    dest = ByteBuffer.wrap(buff);
                    this.io.readAll(dest);
                    String arg = new String(buff, this.charset);
                    this.args.add(arg);
                    payload -= 2 + len;
                }
                break;
            }
            case 21: 
            case 22: {
                this.length = this.io.readLong(this.destLong);
                break;
            }
            case 23: {
                this.data = ByteBuffer.allocate(--payload);
                this.io.readAll(this.data);
                this.data.position(0);
                break;
            }
            case 33: {
                try {
                    this.uri = URIHelper.create(this.charset, this.io.readString(this.destShort, this.charset));
                    break;
                }
                catch (URISyntaxException e) {
                    throw new IOException(e.getMessage());
                }
            }
            case 49: 
            case 51: {
                break;
            }
            default: {
                throw new IOException("Bad response: type " + Integer.toHexString(this.type));
            }
        }
    }

    public int getBlockId() throws IOException {
        return this.blockId;
    }

    public int getAnchorId() throws IOException {
        return this.anchorId;
    }

    public byte getType() throws IOException {
        return this.type;
    }

    public long getLength() throws IOException {
        return this.length;
    }

    public String getMessage() throws IOException {
        return this.message;
    }

    public String[] getArgs() throws IOException {
        return this.args.toArray(new String[this.args.size()]);
    }

    public URI getURI() throws IOException {
        return this.uri;
    }

    public String getMimeType() throws IOException {
        return this.mimeType;
    }

    public String getEncoding() throws IOException {
        return this.encoding;
    }

    public short getCode() throws IOException {
        return this.code;
    }

    public byte getMode() throws IOException {
        return this.mode;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.data.remaining() <= 0) {
            return -1;
        }
        len = Math.min(len, this.data.remaining());
        this.data.get(b, off, len);
        return len;
    }
}

