/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.driver.ctip.common;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

public final class ChannelIO {
    private final ByteChannel channel;
    private final long timeout;
    private final Selector rwselector;
    private final Selector rselector;
    private final Selector wselector;

    public ChannelIO(ByteChannel channel, long timeout) throws IOException {
        this.channel = channel;
        this.timeout = timeout;
        if (this.getSelectable().isBlocking()) {
            this.wselector = null;
            this.rselector = null;
            this.rwselector = null;
        } else {
            this.rwselector = this.getSelectable().provider().openSelector();
            this.getSelectable().register(this.rwselector, 5);
            this.rselector = this.getSelectable().provider().openSelector();
            this.getSelectable().register(this.rselector, 1);
            this.wselector = this.getSelectable().provider().openSelector();
            this.getSelectable().register(this.wselector, 4);
        }
    }

    public ByteChannel getChannel() {
        return this.channel;
    }

    public SelectableChannel getSelectable() {
        return (SelectableChannel)((Object)this.channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.rwselector != null) {
                this.rwselector.close();
            }
            if (this.rselector != null) {
                this.rselector.close();
            }
            if (this.wselector != null) {
                this.wselector.close();
            }
        }
        finally {
            this.channel.close();
        }
    }

    public byte readByte(ByteBuffer destByte) throws IOException {
        this.readAll(destByte);
        return destByte.get(0);
    }

    public short readShort(ByteBuffer destShort) throws IOException {
        this.readAll(destShort);
        return destShort.getShort(0);
    }

    public int readInt(ByteBuffer destInt) throws IOException {
        this.readAll(destInt);
        return destInt.getInt(0);
    }

    public long readLong(ByteBuffer destLong) throws IOException {
        this.readAll(destLong);
        return destLong.getLong(0);
    }

    public String readString(ByteBuffer destShort, String encoding) throws IOException {
        short len = this.readShort(destShort);
        if (len == 0) {
            return "";
        }
        byte[] buff = this.readBytes(len);
        return new String(buff, encoding);
    }

    public byte[] readBytes(int len) throws IOException {
        byte[] buff = new byte[len];
        ByteBuffer dest = ByteBuffer.wrap(buff);
        this.readAll(dest);
        return buff;
    }

    public SelectionKey rwselect() throws IOException {
        if (this.rwselector.select(this.timeout) <= 0) {
            throw new IOException("Read-write timeout");
        }
        SelectionKey key = this.rwselector.selectedKeys().iterator().next();
        this.rwselector.selectedKeys().clear();
        return key;
    }

    public void readAll(ByteBuffer dest) throws IOException {
        dest.position(0);
        do {
            if (this.rselector != null) {
                if (this.rselector.select(this.timeout) <= 0) {
                    throw new IOException("Read timeout");
                }
                this.rselector.selectedKeys().clear();
            }
            if (this.channel.read(dest) != -1) continue;
            throw new EOFException();
        } while (dest.remaining() > 0);
    }

    public void writeAll(ByteBuffer src) throws IOException {
        src.position(0);
        do {
            if (this.wselector != null) {
                if (this.wselector.select(this.timeout) <= 0) {
                    throw new IOException("Write timeout");
                }
                this.wselector.selectedKeys().clear();
            }
            this.channel.write(src);
        } while (src.remaining() > 0);
    }

    public static byte[] toBytes(String str, String encoding) throws IOException {
        if (str == null) {
            str = "";
        }
        return str.getBytes(encoding);
    }
}

