/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.cssj.resolver.Source;
import jp.cssj.resolver.SourceValidity;
import jp.cssj.resolver.helpers.UnknownSourceValidity;

public class CachedSource
implements Source {
    private static final Logger LOG = Logger.getLogger(CachedSource.class.getName());
    private final URI uri;
    private final String mimeType;
    private final String encoding;
    private final File file;
    private InputStream in = null;

    public CachedSource(URI uri, String mimeType, String encoding, File file) {
        this.uri = uri;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.file = file;
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in != null) {
            this.close();
        }
        this.in = new FileInputStream(this.file);
        return this.in;
    }

    public Reader getReader() throws IOException {
        if (!this.isReader()) {
            throw new UnsupportedOperationException();
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    public boolean isFile() {
        return true;
    }

    public File getFile() {
        return this.file;
    }

    public void close() {
        if (this.in != null) {
            try {
                try {
                    this.in.close();
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "\u30ea\u30bd\u30fc\u30b9\u3078\u306e\u63a5\u7d9a\u3092\u4e2d\u65ad\u3057\u305f\u969b\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
                    this.in = null;
                }
            }
            finally {
                this.in = null;
            }
        }
    }

    public boolean exists() throws IOException {
        return true;
    }

    public boolean isInputStream() throws IOException {
        return true;
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    public boolean isReader() throws IOException {
        return this.encoding != null;
    }

    protected void finalize() {
        this.close();
    }

    public SourceValidity getValidity() {
        return UnknownSourceValidity.SHARED_INSTANCE;
    }
}

