#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
sys.path.append('../../code/')

import os
import os.path
from cti import *

# セッションの開始
with get_session('ctip://localhost:8099/',{
    'user'  :'user',
    'password'  :'kappa'
}) as session:
    # ファイル出力
    dir = 'out';
    if not os.path.exists(dir):
        os.mkdir(dir)
    session.set_output_as_file('out/reset-1.pdf')

    # リソースの送信
    with session.resource('test.css') as out:
        with open('data/test.css') as file:
            out.write(file.read())
  
    # 文書の送信
    with session.transcode() as out:
        with open('data/test.html') as file:
            out.write(file.read())

    # 事前に送って変換
    session.set_output_as_file('out/reset-2.pdf')
    with session.resource('test.html') as out:
        with open('data/test.html') as file:
            out.write(file.read())
    session.transcode_server('test.html')
  
    # 同じ文書を変換
    session.set_output_as_file('out/reset-3.pdf')
    session.transcode_server('test.html')
    
    # リセットして変換
    session.reset()
    session.set_output_as_file('out/reset-4.pdf')
    session.transcode_server('test.html')
  
    # 再度変換
    session.set_output_as_file('out/reset-5.pdf')
    with session.transcode('test.html') as out:
        with open('data/test.html') as file:
            out.write(file.read())
