/*
 * Decompiled with CFR 0.152.
 */
package jp.cssj.resolver.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.cssj.resolver.SourceValidity;
import jp.cssj.resolver.helpers.AbstractSource;
import jp.cssj.resolver.zip.ZipFileSourceValidity;

public class ZipFileSource
extends AbstractSource {
    private static final Logger LOG = Logger.getLogger(ZipFileSource.class.getName());
    private final ZipFile zip;
    private final ZipEntry entry;
    private final String encoding;
    private String mimeType = null;

    public ZipFileSource(ZipFile zip, URI uri, String mimeType, String encoding) {
        super(uri);
        if (zip == null) {
            throw new NullPointerException();
        }
        String path = uri.getSchemeSpecificPart();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "URI\u3092\u30c7\u30b3\u30fc\u30c9\u3067\u304d\u307e\u305b\u3093\u3002", e);
        }
        this.entry = zip.getEntry(path);
        this.zip = zip;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public ZipFileSource(ZipFile zip, URI uri, String mimeType) {
        this(zip, uri, mimeType, null);
    }

    public ZipFileSource(ZipFile zip, URI uri) throws IOException {
        this(zip, uri, null);
    }

    public String getMimeType() throws IOException {
        String name;
        int dot;
        if (this.mimeType == null && (dot = (name = this.entry.getName()).indexOf(46)) != -1) {
            String suffix = name.substring(dot, name.length());
            if (suffix.equalsIgnoreCase(".html") || suffix.equalsIgnoreCase(".htm")) {
                this.mimeType = "text/html";
            } else if (suffix.equalsIgnoreCase(".xml") || suffix.equalsIgnoreCase(".xhtml") || suffix.equalsIgnoreCase(".xht")) {
                this.mimeType = "text/xml";
            }
        }
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean exists() throws IOException {
        return this.entry != null;
    }

    public boolean isFile() throws IOException {
        return false;
    }

    public boolean isInputStream() throws IOException {
        return true;
    }

    public boolean isReader() throws IOException {
        return this.encoding != null;
    }

    public InputStream getInputStream() throws IOException {
        return this.zip.getInputStream(this.entry);
    }

    public Reader getReader() throws IOException {
        if (!this.isReader()) {
            throw new UnsupportedOperationException();
        }
        return new InputStreamReader(this.getInputStream(), this.encoding);
    }

    public File getFile() {
        throw new UnsupportedOperationException();
    }

    public long getLength() throws IOException {
        if (this.exists()) {
            return -1L;
        }
        return 0L;
    }

    public SourceValidity getValidity() throws IOException {
        File file = new File(this.zip.getName());
        long timestamp = file.lastModified();
        return new ZipFileSourceValidity(timestamp, file);
    }
}

