#!/usr/bin/perl
=head1 NAME

クライアント側リソース変換サンプル

=head2 概要

test.css,test.htmlを変換します。

=cut
use strict;
use lib '../code';
use CTI::DriverManager;
use CTI::Results::SingleResult;

my $uri = 'ctip://localhost:8099/';
my $session = CTI::DriverManager::get_session($uri,
	user => 'user', password => 'kappa');

$session->set_message_func(sub {
	my ($code, $message, @args) = @_;
	printf "%X %s: %s\n", $code, $message, join(",", @args);
});
$session->set_progress_func(sub {
	my ($length, $read) = @_;
	print "[$read / $length]\n";
});

print $session->get_server_info('http://www.cssj.jp/ns/ctip/version');

$session->set_output_as_file("out/test.pdf");
$session->property('input.include', '**');
$session->transcode('http://www.yahoo.co.jp/');

$session->set_output_as_file("out/test2.pdf");
{
	$session->start_resource(*STDOUT, 'xslt_files/w3c_home');
	open(my $rfp, '<xslt_files/w3c_home');
	while (<$rfp>) {print};
	close($rfp);
	$session->end_resource(*STDOUT);
}
{
	$session->start_resource(*STDOUT, 'xslt_files/W3C-REC');
	open(my $rfp, '<xslt_files/W3C-REC');
	while (<$rfp>) {print};
	close($rfp);
	$session->end_resource(*STDOUT);
}
$session->start_main(*STDOUT, 'xslt.html');
open(my $rfp, '<xslt.html');
while (<$rfp>) {print};
close($rfp);
$session->end_main(*STDOUT);

$session->reset();
$session->set_output_as_file("out/test3.pdf");
$session->set_resolver_func(sub {
	my ($uri, $open) = @_;
	if (-e $uri) {
	  my $fp = $open->();
	  open(my $rfp, "<$uri");
	  while (<$rfp>) {print $fp $_};
	  close($rfp);
	}
	return undef;
});
$session->start_main(*STDOUT, 'xslt.html');
my $data = '';
open($rfp, '<xslt.html');
while (<$rfp>) {$data .= $_;};
close($rfp);
print $data;
$session->end_main(*STDOUT);

$session->reset();
$session->set_output_as_directory('out', '', '.png');
$session->property('output.type', 'image/png');
$session->property('output.pdf.fonts.policy', 'embedded');
$session->transcode('http://www.astroarts.co.jp/news/2009/07/08oldest_granite/index-j.shtml');

$session->close();
