package jp.cssj.cti.resolver;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;

/**
 * java.net.URL𗘗pă\[X܂B
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: URISourceResolver.java,v 1.3 2005/08/18 04:51:26 harumanx Exp $
 */
public class URISourceResolver implements SourceResolver {
	private HashSet sources = new HashSet();

	private String referer = null;

	public void setReferer(String referer) {
		this.referer = referer;
	}

	public String getReferer() {
		return this.referer;
	}

	public Source resolve(String uri) throws IOException {
		URISource source = new URISource(uri, null, null, this.referer);
		this.sources.add(source);
		return source;
	}

	public void release(Source source) {
		this.sources.remove(source);
		((URISource) source).close();
	}

	public void close() {
		for (Iterator i = this.sources.iterator(); i.hasNext();) {
			URISource source = (URISource) i.next();
			source.close();
		}
	}

}