package jp.cssj.cti;

import java.io.IOException;
import java.io.OutputStream;

import jp.cssj.cti.helpers.ErrorHandler;
import jp.cssj.cti.helpers.ProgressListener;

/**
 * <p>
 * T[o[ƈA̕ϊs邽߂́AXe[gtȃZbVłB
 * <p>
 * 1̃ZbVŐł̂1̌ʂ݂̂łB
 * <p>
 * f[^̑M̓Xg[čs܂B t@CȂǂȒPɑM邽߂̃[eBeBCTIUtilsŒ񋟂Ă܂B
 * 
 * <p>
 * <i>̃o[Wł́Axɕ̌ʂ𐶐邽߂ɁAKeep-AliveT|[g\܂B </i>
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: CTISession.java,v 1.2 2005/08/18 04:51:26 harumanx Exp $
 */
public interface CTISession {
	/**
	 * <p>
	 * o͐ݒ肵܂B
	 * 
	 * <p>
	 * ̃\bh͖{̂̊JnOɌĂԕKv܂B
	 * xĂ΂ȂꍇAo͐System.out,o̓^Cv"application/pdf"ɂȂ܂B
	 * 
	 * @param out
	 *            o͐Xg[
	 * @param mimeType
	 *            o̓f[^MIME^(ȗꍇnull)
	 */
	public void setOutput(OutputStream out, String mimeType) throws IOException;

	/**
	 * <p>
	 * G[󂯎邽߂̃IuWFNgݒ肵܂B
	 * 
	 * <p>
	 * ̃\bh͖{̂̊JnOɌĂԕKv܂B
	 * 
	 * @see ErrorHandler
	 * @param eh
	 *            G[nh
	 */
	public void setErrorHandler(ErrorHandler eh);

	/**
	 * <p>
	 * is󋵂Ď邽߂̃IuWFNgݒ肵܂B
	 * 
	 * <p>
	 * ̃\bh͖{̂̊JnOɌĂԕKv܂B
	 * 
	 * <p>
	 * ́Af[^̕ϊ󋵂ĎړIȊOɁAo͌ʂ̒擾邽߂ɂp܂B
	 * HTTPʐMȂǂContent-Lengthwb_𑗏oꍇ͏dvłB
	 * 
	 * @see ProgressListener
	 * @param l
	 *            is󋵃Xi
	 */
	public void setProgressListener(ProgressListener l);

	/**
	 * <p>
	 * vpeBݒ肵܂B
	 * 
	 * <p>
	 * ̃\bh͖{̂̊JnOɌĂԕKv܂B
	 * 
	 * @param name
	 *            vpeB
	 * @param value
	 *            l
	 * @throws IOException
	 */
	public void setProperty(String name, String value) throws IOException;

	/**
	 * <p>
	 * T[o[̃ANZX郊\[Xw肵܂B
	 * 
	 * <p>
	 * ̃\bh͖{̂̊JnOɌĂԕKv܂B
	 * 
	 * <p>
	 * \[X̎wɂ̓ChJ[h܂ނƂoAURIp^[p܂B ڍׂ́uJ҃KChvQƂĂB
	 * 
	 * @param uriPattern
	 *            URIp^[
	 * @throws IOException
	 */
	public void includeResource(String uriPattern) throws IOException;

	/**
	 * <p>
	 * T[o[̃ANZX֎~郊\[Xw肵܂B
	 * 
	 * <p>
	 * ̃\bh͖{̂̊JnOɌĂԕKv܂B
	 * 
	 * <p>
	 * \[X̎wɂ̓ChJ[h܂ނƂoAURIp^[p܂B ڍׂ́uJ҃KChvQƂĂB
	 * 
	 * @param uriPattern
	 *            URIp^[
	 * @throws IOException
	 */
	public void excludeResource(String uriPattern) throws IOException;

	/**
	 * <p>
	 * ϊ郊\[X({)w肷ƓɁA{̂̕ϊJn܂B
	 * 
	 * <p>
	 * ̃\bh́A1̃ZbVɑ΂ĈxĂԂƂo܂B
	 * 
	 * @param uri
	 *            T[o[̖{̂URI
	 * @throws IOException
	 */
	public void formatMain(String uri) throws IOException;

	/**
	 * <p>
	 * \[X𑗐M邽߂̏o̓Xg[Ԃ܂B
	 * 
	 * <p>
	 * <strong>\[X𑗐MAo̓Xg[͕KN[YĂB </strong>
	 * 
	 * <p>
	 * ̃\bh͖{̂̊JnOɌĂԕKv܂B
	 * 
	 * @param uri
	 *            \[X̉zURI
	 * @param mimeType
	 *            \[XMIME^(ȗꍇnull)
	 * @param encoding
	 *            \[X̃GR[fBO(ȗꍇnull)
	 * @return T[o[ւ̏o̓Xg[B
	 * @throws IOException
	 */
	public OutputStream sendResource(String uri, String mimeType,
			String encoding) throws IOException;

	/**
	 * <p>
	 * {̂𑗐M邽߂̏o̓Xg[Ԃ܂B
	 * 
	 * <p>
	 * <strong>{̂𑗐MAo̓Xg[͕KN[YĂB </strong>
	 * 
	 * <p>
	 * ̃\bh́A1̃ZbVɑ΂ĈxĂԂƂo܂B
	 * 
	 * @param uri
	 *            {̂̉zURI
	 * @param mimeType
	 *            {̂MIME^(ȗꍇnull)
	 * @param encoding
	 *            {̂̃GR[fBO(ȗꍇnull)
	 * @return T[o[ւ̏o̓Xg[B
	 * @throws IOException
	 */
	public OutputStream sendMain(String uri, String mimeType, String encoding)
			throws IOException;

	/**
	 * <p>
	 * ZbVN[Y܂B
	 * 
	 * <p>
	 * ̃\bhĂяóAZbVɑ΂ĉo܂B
	 * 
	 * @throws IOException
	 */
	public void close() throws IOException;
}