package jp.cssj.cti.helpers;

import java.io.Serializable;

/**
 * int̉ϒzłB
 * 
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: IntList.java,v 1.3 2005/08/18 04:51:26 harumanx Exp $
 */
public class IntList implements Serializable {
	private static final long serialVersionUID = 0L;

	private final int buffer;

	private int[] array;

	private int size;

	public IntList(int buffer) {
		this.array = new int[this.buffer = buffer];
	}

	public void add(int value) {
		if (this.array.length <= this.size) {
			int[] array = new int[size + this.buffer];
			System.arraycopy(this.array, 0, array, 0, this.array.length);
			this.array = array;
		}
		this.array[this.size++] = value;
	}

	public int get(int pos) {
		if (pos < 0 || this.size <= pos) {
			throw new ArrayIndexOutOfBoundsException();
		}
		return this.array[pos];
	}

	public int size() {
		return this.size;
	}
}
