package jp.cssj.cti.helpers;

import java.io.IOException;
import java.io.OutputStream;

/**
 * @author <a href="mailto:miyabe at gnn.co.jp">MIYABE Tatsuhiko </a>
 * @version $Id: ContentBuilderOutputStream.java,v 1.2 2005/06/03 12:22:16
 *          harumanx Exp $
 */
public class ContentBuilderOutputStream extends OutputStream {
	private final ContentBuilder builder;

	private final int fragmentId;

	private final byte[] buff = new byte[1];

	public ContentBuilderOutputStream(ContentBuilder builder, int fragmentId) {
		this.builder = builder;
		this.fragmentId = fragmentId;
	}

	public void write(int b) throws IOException {
		this.buff[0] = (byte) b;
		this.builder.write(this.fragmentId, this.buff, 0, 1);
	}

	public void write(byte[] b, int off, int len) throws IOException {
		this.builder.write(this.fragmentId, b, off, len);
	}

	public void write(byte[] b) throws IOException {
		this.builder.write(this.fragmentId, b, 0, b.length);
	}

	public void close() throws IOException {
		this.builder.close(this.fragmentId);
	}
}