/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordsParser
implements ITypeParser {
    private static String NAMESPACE = "http://concierge.sourceforge.jp/ns/keywords";
    private static String PREFIX = "kwd";
    private static String TAGNAME = "word";
    private static String[] DELIMITERS = new String[]{",", ";", "\ufffdC", "\ufffdG"};
    private static String MESSAGE = "Each word must be separate by a COMMA, e.g. \"word1, word2\".";

    @Override
    public String getParserNS() {
        return NAMESPACE;
    }

    @Override
    public String getParserNSPrefix() {
        return PREFIX;
    }

    @Override
    public String getSingleText(Element data) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        String out = "";
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            out = i == 0 ? DataDomImpl.getElementText(e) : String.valueOf(out) + DELIMITERS[0] + " " + DataDomImpl.getElementText(e);
            ++i;
        }
        return out;
    }

    @Override
    public ArrayList<String> getMultiText(Element data) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            String str = DataDomImpl.getElementText(e);
            if (str.trim().length() > 0) {
                out.add(str);
            }
            ++i;
        }
        return out;
    }

    @Override
    public ArrayList<String> getIndexValues(Element data, String abc) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            String str = DataDomImpl.getElementText(e);
            if (str.trim().length() > 0) {
                if (abc != null) {
                    if (str.substring(0, abc.length()).compareToIgnoreCase(abc) == 0) {
                        out.add(str);
                    }
                } else {
                    out.add(str);
                }
            }
            ++i;
        }
        return out;
    }

    @Override
    public ArrayList<String> getIndexABC(Element data) {
        ArrayList<Element> in = DataDomImpl.getElements(data, TAGNAME, PREFIX);
        ArrayList<String> out = new ArrayList<String>();
        int i = 0;
        while (i < in.size()) {
            Element e = in.get(i);
            String str = DataDomImpl.getElementText(e);
            if (str.trim().length() > 0) {
                String abc = str.substring(0, 1).toUpperCase();
                out.add(abc);
            }
            ++i;
        }
        return out;
    }

    @Override
    public void putToElement(Element data, String str) {
        if (str == null) {
            return;
        }
        ArrayList<String> wordList = new ArrayList<String>();
        wordList.add(str);
        int i = 0;
        while (i < DELIMITERS.length) {
            Iterator ite = wordList.iterator();
            wordList = new ArrayList();
            while (ite.hasNext()) {
                String[] tmp = ((String)ite.next()).split(DELIMITERS[i]);
                wordList.addAll((Collection<String>)Arrays.asList(tmp));
            }
            ++i;
        }
        this.putToElement(data, wordList);
    }

    public void putToElement(Element data, ArrayList<String> wordList) {
        if (wordList == null) {
            return;
        }
        DataDomImpl.removeAllChildren(data);
        int i = 0;
        while (i < wordList.size()) {
            String word = wordList.get(i).trim();
            this.addKeywordToElement(data, word);
            ++i;
        }
    }

    public void putToElement(Element data, String[] strList) {
        if (strList == null) {
            return;
        }
        DataDomImpl.removeAllChildren(data);
        int i = 0;
        while (i < strList.length) {
            String word = strList[i].trim();
            this.addKeywordToElement(data, word);
            ++i;
        }
    }

    public void addKeywordToElement(Element data, String word) {
        if (word != null & word.length() > 0) {
            Element e = DataDomImpl.appendElement(data, TAGNAME, PREFIX);
            DataDomImpl.setElementText(e, word);
        }
    }

    @Override
    public String getMessage() {
        return MESSAGE;
    }
}

