/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.DataExtractorPlugin;
import jp.sourceforge.concierge.plugin.IFileFilter;
import jp.sourceforge.concierge.plugin.ImageToolTip;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class DataExtractor
extends ViewPart {
    private Label filepath;
    private TableViewer viewer;
    private ScrolledComposite scomp;
    private Composite imgcomp;
    private Action fileAction;
    private Action thumbnailAction;
    private IFileFilter ffilter;
    private Image curimage;

    private void disposeImageLabels() {
        Control[] ctrls = this.imgcomp.getChildren();
        int i = 0;
        while (i < ctrls.length) {
            Label cl = (Label)ctrls[i];
            Image img = (Image)cl.getData("OImage");
            if (img != null) {
                img.dispose();
            }
            if ((img = cl.getImage()) != null) {
                img.dispose();
            }
            cl.dispose();
            ++i;
        }
    }

    private void setMenu(Control ctrl) {
        MenuManager mm = new MenuManager("#CCGPopupMenu");
        Menu menu = mm.createContextMenu(ctrl);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)DataExtractor.this.thumbnailAction);
            }
        });
        ctrl.setMenu(menu);
    }

    private Image getResizedImage(Image img, int maxx, int maxy) {
        ImageData id = img.getImageData();
        double ratiox = (double)maxx / (double)id.width;
        double ratioy = (double)maxy / (double)id.height;
        double ratio = ratiox > ratioy ? ratioy : ratiox;
        ImageData nid = id.scaledTo((int)((double)id.width * ratio), (int)((double)id.height * ratio));
        Image nimg = new Image(img.getDevice(), nid);
        return nimg;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, true));
        this.filepath = new Label(parent, 0);
        GridData fgd = new GridData(768);
        fgd.horizontalSpan = 3;
        this.filepath.setLayoutData((Object)fgd);
        this.viewer = new TableViewer(parent, 0);
        GridData vgd = new GridData(1808);
        vgd.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)vgd);
        TableColumn tc = new TableColumn(this.viewer.getTable(), 0);
        tc.setText("Item");
        tc.setWidth(100);
        tc.setMoveable(false);
        tc.setResizable(true);
        tc = new TableColumn(this.viewer.getTable(), 0);
        tc.setText("Value");
        tc.setWidth(200);
        tc.setMoveable(false);
        tc.setResizable(true);
        this.scomp = new ScrolledComposite(parent, 768);
        this.scomp.setLayoutData((Object)new GridData(1808));
        this.imgcomp = new Composite((Composite)this.scomp, 0);
        this.imgcomp.setBackground(this.imgcomp.getDisplay().getSystemColor(16));
        this.scomp.setContent((Control)this.imgcomp);
        this.scomp.setExpandHorizontal(true);
        this.scomp.setExpandVertical(true);
        RowLayout rl = new RowLayout();
        rl.fill = true;
        rl.wrap = true;
        this.imgcomp.setLayout((Layout)rl);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fileAction = new Action(){

            public void run() {
                FileDialog fd = new FileDialog(DataExtractor.this.viewer.getControl().getShell(), 4096);
                String path = fd.open();
                if (path != null && path.length() > 0) {
                    DataExtractor.this.filepath.setText(path);
                    try {
                        if (DataExtractor.this.ffilter != null) {
                            DataExtractor.this.ffilter.close();
                        }
                        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                        DataExtractor.this.viewer.setInput(null);
                        DataExtractor.this.ffilter = DataExtractorPlugin.getFilter(path);
                        if (DataExtractor.this.ffilter == null) {
                            return;
                        }
                        String[] keys = DataExtractor.this.ffilter.getDataNames();
                        int i = 0;
                        while (i < keys.length) {
                            String v = DataExtractor.this.ffilter.getData(keys[i]);
                            if (v != null) {
                                kvs.add(new KeyValue(keys[i], v));
                            }
                            ++i;
                        }
                        DataExtractor.this.viewer.setInput(kvs);
                        DataExtractor.this.disposeImageLabels();
                        ArrayList<Image> imgs = DataExtractor.this.ffilter.getImages();
                        int i2 = 0;
                        while (i2 < imgs.size()) {
                            Label l = new Label(DataExtractor.this.imgcomp, 2048);
                            l.setLayoutData((Object)new RowData(50, 50));
                            l.setData("OImage", (Object)DataExtractor.this.getResizedImage(imgs.get(i2), 200, 200));
                            l.setBackground(l.getDisplay().getSystemColor(16));
                            l.setImage(DataExtractor.this.getResizedImage(imgs.get(i2), 50, 50));
                            ImageToolTip itt = new ImageToolTip((Control)l, 0, true);
                            l.setData("ToolTip", (Object)itt);
                            DataExtractor.this.setMenu((Control)l);
                            l.addMouseTrackListener(new MouseTrackListener(){

                                public void mouseHover(MouseEvent e) {
                                }

                                public void mouseEnter(MouseEvent e) {
                                    Label ll = (Label)e.widget;
                                    ImageToolTip itt = (ImageToolTip)((Object)ll.getData("ToolTip"));
                                    Image img = (Image)ll.getData("OImage");
                                    itt.setImage(img);
                                    Point p = ll.getSize();
                                    itt.show(new Point(p.x / 2, p.y / 2));
                                    DataExtractor.this.curimage = DataExtractor.this.getResizedImage(img, 100, 100);
                                }

                                public void mouseExit(MouseEvent e) {
                                    Label ll = (Label)e.widget;
                                    ImageToolTip itt = (ImageToolTip)((Object)ll.getData("ToolTip"));
                                    if (itt == null) {
                                        return;
                                    }
                                }
                            });
                            imgs.get(i2).dispose();
                            ++i2;
                        }
                        DataExtractor.this.imgcomp.layout();
                        DataExtractor.this.scomp.setMinSize(DataExtractor.this.imgcomp.getSize());
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                    }
                }
            }
        };
        this.fileAction.setToolTipText("open file.");
        this.fileAction.setImageDescriptor(DataExtractorPlugin.getImageDescriptor("icons/openfile.png"));
        this.thumbnailAction = new Action(){

            public void run() {
                if (DataExtractor.this.ffilter == null || DataExtractor.this.curimage == null) {
                    return;
                }
                DataExtractor.this.ffilter.setThumbnail(DataExtractor.this.curimage);
            }
        };
        this.thumbnailAction.setText("Set thumbnail");
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.fileAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.disposeImageLabels();
    }

    private class KeyValue {
        public String key;
        public String value;

        public KeyValue(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object dataset) {
            return ((ArrayList)dataset).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int index) {
            return null;
        }

        public String getColumnText(Object element, int index) {
            TableColumn tc = DataExtractor.this.viewer.getTable().getColumn(index);
            String title = tc.getText();
            KeyValue kv = (KeyValue)element;
            if (title.compareTo("Item") == 0) {
                return kv.key;
            }
            if (title.compareTo("Value") == 0) {
                return kv.value;
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

