/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.internal.ConfigureColumnsDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.eclipse.ui.internal.dialogs.BundleSigningTray;
import org.eclipse.ui.internal.dialogs.ProductInfoDialog;
import org.eclipse.ui.internal.dialogs.TableComparator;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.Bundle;

public class AboutPluginsDialog
extends ProductInfoDialog {
    private static final int TABLE_HEIGHT = 200;
    private static final IPath baseNLPath = new Path("$nl$");
    private static final String PLUGININFO = "about.html";
    private static final int MORE_ID = 1025;
    private static final int SIGNING_ID = 1026;
    private static final int COLUMNS_ID = 1027;
    private static final int PLUGIN_NAME_COLUMN_INDEX = 2;
    private TableViewer vendorInfo;
    private Button moreInfo;
    private Button signingInfo;
    private String title;
    private String message;
    private String helpContextId;
    private String[] columnTitles = new String[]{WorkbenchMessages.AboutPluginsDialog_signed, WorkbenchMessages.AboutPluginsDialog_provider, WorkbenchMessages.AboutPluginsDialog_pluginName, WorkbenchMessages.AboutPluginsDialog_version, WorkbenchMessages.AboutPluginsDialog_pluginId};
    private String productName;
    private AboutBundleData[] bundleInfos;

    public AboutPluginsDialog(Shell parentShell, String productName) {
        this(parentShell, productName, WorkbenchPlugin.getDefault().getBundles(), null, null, "org.eclipse.ui.about_plugins_dialog_context");
        WorkbenchPlugin.class.getSigners();
    }

    public AboutPluginsDialog(Shell parentShell, String productName, Bundle[] bundles, String title, String message, String helpContextId) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.helpContextId = helpContextId;
        this.productName = productName;
        HashMap<String, AboutBundleData> map = new HashMap<String, AboutBundleData>();
        int i = 0;
        while (i < bundles.length) {
            AboutBundleData data = new AboutBundleData(bundles[i]);
            if (BundleUtility.isReady(data.getState()) && !map.containsKey(data.getVersionedId())) {
                map.put(data.getVersionedId(), data);
            }
            ++i;
        }
        this.bundleInfos = map.values().toArray(new AboutBundleData[0]);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.handleMoreInfoPressed();
                break;
            }
            case 1026: {
                this.handleSigningInfoPressed();
                break;
            }
            case 1027: {
                this.handleColumnsPressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private void handleColumnsPressed() {
        ConfigureColumnsDialog d = new ConfigureColumnsDialog((IShellProvider)this, this.vendorInfo.getTable());
        d.open();
    }

    private void handleSigningInfoPressed() {
        DialogTray existingTray = this.getTray();
        if (existingTray instanceof BundleSigningTray) {
            this.getButton(1026).setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_show);
            this.closeTray();
        } else {
            this.getButton(1026).setText(WorkbenchMessages.AboutPluginsDialog_signingInfo_hide);
            if (existingTray != null) {
                this.closeTray();
            }
            AboutBundleData bundleInfo = (AboutBundleData)((IStructuredSelection)this.vendorInfo.getSelection()).getFirstElement();
            BundleSigningTray tray = new BundleSigningTray(this);
            tray.setData(bundleInfo);
            this.openTray(tray);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title == null && this.productName != null) {
            this.title = NLS.bind((String)WorkbenchMessages.AboutPluginsDialog_shellTitle, (Object)this.productName);
        }
        if (this.title != null) {
            newShell.setText(this.title);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, this.helpContextId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.moreInfo = this.createButton(parent, 1025, WorkbenchMessages.AboutPluginsDialog_moreInfo, false);
        this.moreInfo.setEnabled(false);
        this.signingInfo = this.createButton(parent, 1026, WorkbenchMessages.AboutPluginsDialog_signingInfo_show, false);
        this.signingInfo.setEnabled(false);
        this.createButton(parent, 1027, WorkbenchMessages.AboutPluginsDialog_columns, false);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(outer, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setFont(parent.getFont());
            label.setText(this.message);
        }
        this.createTable(outer);
        return outer;
    }

    protected void createTable(Composite parent) {
        this.vendorInfo = new TableViewer(parent, 68356);
        this.vendorInfo.setUseHashlookup(true);
        this.vendorInfo.getTable().setHeaderVisible(true);
        this.vendorInfo.getTable().setLinesVisible(true);
        this.vendorInfo.getTable().setFont(parent.getFont());
        this.vendorInfo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof AboutBundleData) {
                    AboutBundleData selected = (AboutBundleData)selection.getFirstElement();
                    AboutPluginsDialog.this.moreInfo.setEnabled(AboutPluginsDialog.this.selectionHasInfo(selected));
                    AboutPluginsDialog.this.signingInfo.setEnabled(true);
                    if (AboutPluginsDialog.this.getTray() instanceof BundleSigningTray) {
                        ((BundleSigningTray)AboutPluginsDialog.this.getTray()).setData(selected);
                    }
                } else {
                    AboutPluginsDialog.this.moreInfo.setEnabled(false);
                    AboutPluginsDialog.this.signingInfo.setEnabled(false);
                }
            }
        });
        TableComparator comparator = new TableComparator();
        this.vendorInfo.setComparator((ViewerComparator)comparator);
        int[] columnWidths = new int[]{this.convertHorizontalDLUsToPixels(30), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(120), this.convertHorizontalDLUsToPixels(70), this.convertHorizontalDLUsToPixels(130)};
        int i = 0;
        while (i < this.columnTitles.length) {
            TableColumn column = new TableColumn(this.vendorInfo.getTable(), 0);
            if (i == 2) {
                this.updateTableSorting(i);
            }
            column.setWidth(columnWidths[i]);
            column.setText(this.columnTitles[i]);
            final int columnIndex = i++;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AboutPluginsDialog.this.updateTableSorting(columnIndex);
                }
            });
        }
        this.vendorInfo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.vendorInfo.setLabelProvider((IBaseLabelProvider)new BundleTableLabelProvider());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertVerticalDLUsToPixels(200);
        this.vendorInfo.getTable().setLayoutData((Object)gridData);
        this.vendorInfo.setInput((Object)this.bundleInfos);
    }

    private void updateTableSorting(int columnIndex) {
        TableComparator comparator = (TableComparator)this.vendorInfo.getComparator();
        if (columnIndex == comparator.getSortColumn()) {
            comparator.setAscending(!comparator.isAscending());
        }
        comparator.setSortColumn(columnIndex);
        this.vendorInfo.getTable().setSortColumn(this.vendorInfo.getTable().getColumn(columnIndex));
        this.vendorInfo.getTable().setSortDirection(comparator.isAscending() ? 128 : 1024);
        this.vendorInfo.refresh(false);
    }

    private boolean selectionHasInfo(AboutBundleData bundleInfo) {
        URL infoURL = this.getMoreInfoURL(bundleInfo, false);
        if (infoURL == null && WorkbenchPlugin.DEBUG) {
            WorkbenchPlugin.log("Problem reading plugin info for: " + bundleInfo.getName());
        }
        return infoURL != null;
    }

    protected void handleMoreInfoPressed() {
        if (this.vendorInfo == null) {
            return;
        }
        if (this.vendorInfo.getSelection().isEmpty()) {
            return;
        }
        AboutBundleData bundleInfo = (AboutBundleData)((IStructuredSelection)this.vendorInfo.getSelection()).getFirstElement();
        if (!this.openBrowser(this.getMoreInfoURL(bundleInfo, true))) {
            String message = NLS.bind((String)WorkbenchMessages.AboutPluginsDialog_unableToOpenFile, (Object)PLUGININFO, (Object)bundleInfo.getId());
            StatusUtil.handleStatus(String.valueOf(WorkbenchMessages.AboutPluginsDialog_errorTitle) + ": " + message, 2, this.getShell());
        }
    }

    private URL getMoreInfoURL(AboutBundleData bundleInfo, boolean makeLocal) {
        Bundle bundle = Platform.getBundle((String)bundleInfo.getId());
        if (bundle == null) {
            return null;
        }
        URL aboutUrl = Platform.find((Bundle)bundle, (IPath)baseNLPath.append(PLUGININFO), null);
        if (!makeLocal) {
            return aboutUrl;
        }
        if (aboutUrl != null) {
            try {
                URL result = Platform.asLocalURL((URL)aboutUrl);
                try {
                    URL about = new URL(aboutUrl, "about_files");
                    if (about != null) {
                        Platform.asLocalURL((URL)about);
                    }
                }
                catch (IOException iOException) {}
                return result;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public class BundleTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private LinkedList resolveQueue = new LinkedList();
        private List updateQueue = new ArrayList();
        private Job resolveJob = new Job(AboutPluginsDialog.class.getName()){
            {
                this.setSystem(true);
                this.setPriority(20);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                while (true) {
                    AboutBundleData data = null;
                    Shell dialogShell = AboutPluginsDialog.this.getShell();
                    if (dialogShell == null || dialogShell.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    List list = BundleTableLabelProvider.this.resolveQueue;
                    synchronized (list) {
                        if (BundleTableLabelProvider.this.resolveQueue.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        data = (AboutBundleData)BundleTableLabelProvider.this.resolveQueue.removeFirst();
                    }
                    try {
                        data.isSigned();
                        list = BundleTableLabelProvider.this.updateQueue;
                        synchronized (list) {
                            BundleTableLabelProvider.this.updateQueue.add(data);
                        }
                        BundleTableLabelProvider.this.updateJob.schedule();
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        continue;
                    }
                    break;
                }
            }
        };
        private Job updateJob;

        public BundleTableLabelProvider() {
            this.updateJob = new WorkbenchJob(AboutPluginsDialog.this.getShell().getDisplay(), AboutPluginsDialog.class.getName()){
                {
                    this.setSystem(true);
                    this.setPriority(50);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Shell dialogShell;
                    while ((dialogShell = AboutPluginsDialog.this.getShell()) != null && !dialogShell.isDisposed()) {
                        Object[] data = null;
                        List list = BundleTableLabelProvider.this.updateQueue;
                        synchronized (list) {
                            if (BundleTableLabelProvider.this.updateQueue.isEmpty()) {
                                return Status.OK_STATUS;
                            }
                            data = BundleTableLabelProvider.this.updateQueue.toArray(new AboutBundleData[BundleTableLabelProvider.this.updateQueue.size()]);
                            BundleTableLabelProvider.this.updateQueue.clear();
                        }
                        BundleTableLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BundleTableLabelProvider.this, data));
                    }
                    return Status.OK_STATUS;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof AboutBundleData) {
                AboutBundleData data = (AboutBundleData)element;
                if (data.isSignedDetermined()) {
                    return WorkbenchImages.getImage(data.isSigned() ? "IMG_OBJ_SIGNED_YES" : "IMG_OBJ_SIGNED_NO");
                }
                LinkedList linkedList = this.resolveQueue;
                synchronized (linkedList) {
                    this.resolveQueue.add(data);
                }
                this.resolveJob.schedule();
                return WorkbenchImages.getImage("IMG_OBJ_SIGNED_UNKNOWN");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof AboutBundleData) {
                AboutBundleData data = (AboutBundleData)element;
                switch (columnIndex) {
                    case 1: {
                        return data.getProviderName();
                    }
                    case 2: {
                        return data.getName();
                    }
                    case 3: {
                        return data.getVersion();
                    }
                    case 4: {
                        return data.getId();
                    }
                }
            }
            return "";
        }
    }
}

