/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.IVisitor;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.properties.PropertyStore;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.properties.StoredProperty;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public class PropertyStoreConverter {
    public IStatus convertProperties(Workspace workspace, final PropertyManager2 destination) {
        File versionFile = destination.getVersionFile();
        if (versionFile.isFile()) {
            return Status.OK_STATUS;
        }
        final boolean[] worked = new boolean[1];
        final PropertyManager source = new PropertyManager(workspace);
        try {
            workspace.getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ConversionVisitor propertyConverter = new ConversionVisitor(resource.getFullPath(), destination.getTree());
                    PropertyStore store = source.getPropertyStore(resource, false);
                    if (store == null) {
                        return true;
                    }
                    store.recordsDeepMatching(new ResourceName("", resource.getProjectRelativePath()), propertyConverter);
                    source.closePropertyStore(resource);
                    worked[0] = worked[0] || propertyConverter.hasWorked();
                    return true;
                }
            }, 1, 0);
            destination.getTree().getCurrent().save();
        }
        catch (CoreException e) {
            String conversionFailed = CompatibilityMessages.properties_conversionFailed;
            return new MultiStatus("org.eclipse.core.resources", 567, new IStatus[]{e.getStatus()}, conversionFailed, null);
        }
        if (!worked[0]) {
            return Status.OK_STATUS;
        }
        String conversionOk = CompatibilityMessages.properties_conversionSucceeded;
        return new Status(1, "org.eclipse.core.resources", 0, conversionOk, null);
    }

    class ConversionVisitor
    implements IVisitor {
        private IPath basePath;
        private BucketTree target;
        private boolean worked;

        public ConversionVisitor(IPath basePath, BucketTree target) {
            this.target = target;
            this.basePath = basePath;
        }

        public boolean hasWorked() {
            return this.worked;
        }

        @Override
        public boolean requiresValue(ResourceName resourceName, QualifiedName propertyName) {
            return true;
        }

        @Override
        public void visit(ResourceName resourceName, StoredProperty property, IndexCursor cursor) throws CoreException {
            IPath fullPath = this.basePath.append(resourceName.getPath());
            this.target.loadBucketFor(fullPath);
            ((PropertyBucket)this.target.getCurrent()).setProperty(fullPath, property.getName(), property.getStringValue());
            this.worked = true;
        }
    }
}

