/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.Observable;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.Referable;

public abstract class Page
extends Observable
implements Referable {
    public static final int SIZE = 8192;
    protected int pageNumber;
    protected int referenceCount;
    protected Buffer pageBuffer;
    protected PageStore pageStore;

    public Page(int pageNumber, PageStore pageStore) {
        this.pageNumber = pageNumber;
        this.pageStore = pageStore;
        this.referenceCount = 0;
    }

    @Override
    public int addReference() {
        ++this.referenceCount;
        return this.referenceCount;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public boolean hasReferences() {
        return this.referenceCount > 0;
    }

    public void release() {
        this.pageStore.release(this);
    }

    @Override
    public int removeReference() {
        if (this.referenceCount > 0) {
            --this.referenceCount;
        }
        return this.referenceCount;
    }

    public abstract void toBuffer(byte[] var1);
}

