/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class ObjectHeader
implements Insertable {
    public static final int SIZE = 4;
    private static final int HeaderTagValue = 65535;
    private static final int HeaderTagOffset = 0;
    private static final int ObjectLengthOffset = 2;
    private int objectLength;

    public ObjectHeader(byte[] buffer) throws ObjectStoreException {
        if (buffer.length != 4) {
            throw new IllegalArgumentException();
        }
        Buffer buf = new Buffer(buffer);
        if (buf.getUInt(0, 2) != 65535) {
            throw new ObjectStoreException(26);
        }
        this.objectLength = buf.getUInt(2, 2);
    }

    public ObjectHeader(int objectLength) {
        this.objectLength = objectLength;
    }

    public int getObjectLength() {
        return this.objectLength;
    }

    @Override
    public byte[] toByteArray() {
        Buffer buf = new Buffer(4);
        buf.put(0, 2, 65535);
        buf.put(2, 2, this.objectLength);
        return buf.get();
    }
}

