/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.mdocument;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.parser.ParserManager;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataSchemaConverter {
    private static String getFilePath(Document odoc) {
        return DomImpl.getAttribute(odoc.getDocumentElement(), "filename");
    }

    private static long getLastModDate(Document odoc) {
        return Long.parseLong(DomImpl.getAttribute(odoc.getDocumentElement(), "lastmod"));
    }

    private static long getID(Document odoc) {
        return Long.parseLong(DomImpl.getAttribute(odoc.getDocumentElement(), "id"));
    }

    private static void removeAttributes(Element oelem) {
        oelem.removeAttribute("id");
        oelem.removeAttribute("filebase");
        oelem.removeAttribute("filename");
        oelem.removeAttribute("filepath");
        oelem.removeAttribute("lastmod");
        oelem.removeAttribute("tid");
    }

    private static String getOldText(Element oelem) {
        String pname = DomImpl.getAttribute(oelem, "parser");
        ITypeParser parser = ParserManager.getInstance(pname);
        return parser.getSingleText(oelem);
    }

    private static String getNewFileName(String dir, String name) {
        File nf = new File(String.valueOf(dir) + File.separator + name);
        if (!nf.exists()) {
            return name;
        }
        String bname = FilenameUtils.getBaseName((String)name);
        String ext = FilenameUtils.getExtension((String)name);
        int i = 0;
        while (i < 1000000) {
            File cf = new File(String.valueOf(dir) + File.separator + bname + i + "." + ext);
            if (!cf.exists()) {
                return String.valueOf(bname) + i + "." + ext;
            }
            ++i;
        }
        assert (false);
        return null;
    }

    private static String getRenamedFile(String nfdir, String name, long id) {
        File df = new File(nfdir);
        File[] off = df.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                String bname = FilenameUtils.getBaseName((String)arg1);
                return bname.equals(String.valueOf(id));
            }
        });
        String newfname = String.valueOf(nfdir) + File.separator + DataSchemaConverter.getNewFileName(nfdir, name);
        if (off.length > 0) {
            off[0].renameTo(new File(newfname));
        }
        return newfname;
    }

    private static boolean isAbsolutePath(String path) {
        return !FilenameUtils.getName((String)path).equals(path);
    }

    public static void convertDataToMData(String dbpath) {
        ArrayList<Document> docs;
        File of;
        ArrayList<Document> newdocs = new ArrayList<Document>();
        Request r = new Request(4, "/data", "data");
        ArrayList<Document> olddocs = FrameworkPlugin.getDocumentsOfQuery(r);
        String oldfdir = String.valueOf(dbpath) + File.separator + ".concierge";
        String newfdir = String.valueOf(dbpath) + File.separator + "ccgfiledir";
        if (olddocs.size() > 0 && (of = new File(oldfdir)).exists()) {
            of.renameTo(new File(newfdir));
            new File(oldfdir).mkdir();
        }
        int i = 0;
        while (i < olddocs.size()) {
            Document odoc = olddocs.get(i);
            Document ndoc = DataDomImpl.createDocument();
            String opath = DataSchemaConverter.getFilePath(odoc);
            long oid = DataSchemaConverter.getID(odoc);
            if (DataSchemaConverter.isAbsolutePath(opath) || opath.length() == 0) {
                DataDomImpl.setFilePath(ndoc, opath);
            } else {
                DataDomImpl.setFilePath(ndoc, DataSchemaConverter.getRenamedFile(newfdir, opath, oid));
            }
            DomImpl.setLastModifiedTime(ndoc, DataSchemaConverter.getLastModDate(odoc));
            DomImpl.setID(ndoc, oid);
            String type = DomImpl.getAttribute(DomImpl.getRootElement(odoc), "name");
            if (type.equals("Misc")) {
                ArrayList<Element> elems = DomImpl.getElements(odoc, "Title");
                assert (elems.size() == 1);
                DataDomImpl.setTitle(ndoc, DataSchemaConverter.getOldText(elems.get(0)));
                elems = DomImpl.getElements(odoc, "Keywords");
                assert (elems.size() == 1);
                DataDomImpl.setKeywords(ndoc, DataSchemaConverter.getOldText(elems.get(0)));
                elems = DomImpl.getElements(odoc, "Comment");
                assert (elems.size() == 1);
                DataDomImpl.setComment(ndoc, DataSchemaConverter.getOldText(elems.get(0)));
                DataDomImpl.setDefaultType(ndoc, "Unclassified");
            } else {
                Element ielem = (Element)ndoc.importNode(odoc.getDocumentElement(), true);
                ndoc.getDocumentElement().appendChild(ielem);
                DataSchemaConverter.removeAttributes(ielem);
                DataDomImpl.setDefaultType(ndoc, type);
            }
            newdocs.add(ndoc);
            ++i;
        }
        if (newdocs.size() > 0) {
            r = new Request(2, olddocs, "data");
            FrameworkPlugin.updateDocuments(r, true, null);
            r = new Request(1, newdocs, "data");
            FrameworkPlugin.updateDocuments(r, true, null);
        }
        if ((docs = FrameworkPlugin.getDocumentsOfQuery(r = new Request(4, "/type[@name='Misc']", "type"))) != null && docs.size() > 0) {
            r = new Request(2, docs.get(0), "type");
            FrameworkPlugin.updateDocuments(r, true, null);
        }
    }
}

