/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    long targetList;
    boolean moveData = false;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static Callback DragGetData = new Callback(DragSource.class, "DragGetData", 5);
    static Callback DragEnd;
    static Callback DragDataDelete;

    static {
        if (DragGetData.getAddress() == 0L) {
            SWT.error(3);
        }
        if ((DragEnd = new Callback(DragSource.class, "DragEnd", 2)).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((DragDataDelete = new Callback(DragSource.class, "DragDataDelete", 2)).getAddress() == 0L) {
            SWT.error(3);
        }
    }

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (DragGetData == null || DragEnd == null || DragDataDelete == null) {
            DND.error(2000);
        }
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        OS.g_signal_connect(control.handle, OS.drag_data_get, DragGetData.getAddress(), 0L);
        OS.g_signal_connect(control.handle, OS.drag_end, DragEnd.getAddress(), 0L);
        OS.g_signal_connect(control.handle, OS.drag_data_delete, DragDataDelete.getAddress(), 0L);
        this.controlListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        Object effect = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (effect instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)effect;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
        this.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static long DragDataDelete(long widget, long context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0L;
        }
        source.dragDataDelete(widget, context);
        return 0L;
    }

    static long DragEnd(long widget, long context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0L;
        }
        source.dragEnd(widget, context);
        return 0L;
    }

    static long DragGetData(long widget, long context, long selection_data, long info, long time) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0L;
        }
        source.dragGetData(widget, context, selection_data, (int)info, (int)time);
        return 0L;
    }

    static DragSource FindDragSource(long handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    @Override
    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = DragSource.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    void drag(Event dragEvent) {
        this.moveData = false;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.x = dragEvent.x;
        event.y = dragEvent.y;
        event.time = dragEvent.time;
        event.doit = true;
        this.notifyListeners(2008, event);
        if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        if (this.targetList == 0L) {
            return;
        }
        int actions = this.opToOsOp(this.getStyle());
        Image image = event.image;
        long context = OS.gtk_drag_begin(this.control.handle, this.targetList, actions, 1, 0L);
        if (context != 0L && image != null) {
            long pixbuf = DragSource.createPixbuf(image);
            OS.gtk_drag_set_icon_pixbuf(context, pixbuf, 0, 0);
            OS.g_object_unref(pixbuf);
        }
    }

    void dragEnd(long widget, long context) {
        OS.gdk_pointer_ungrab(0);
        OS.gdk_keyboard_ungrab(0);
        int operation = 0;
        if (context != 0L) {
            GdkDragContext gdkDragContext = new GdkDragContext();
            OS.memmove(gdkDragContext, context, (long)GdkDragContext.sizeof);
            if (gdkDragContext.dest_window != 0L) {
                if (this.moveData) {
                    operation = 2;
                } else {
                    operation = this.osOpToOp(gdkDragContext.action);
                    if (operation == 2) {
                        operation = 0;
                    }
                }
            }
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.doit = operation != 0;
        event.detail = operation;
        this.notifyListeners(2000, event);
        this.moveData = false;
    }

    void dragGetData(long widget, long context, long selection_data, int info, int time) {
        if (selection_data == 0L) {
            return;
        }
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove(gtkSelectionData, selection_data, (long)GtkSelectionData.sizeof);
        if (gtkSelectionData.target == 0L) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = gtkSelectionData.target;
        transferData.pValue = gtkSelectionData.data;
        transferData.length = gtkSelectionData.length;
        transferData.format = gtkSelectionData.format;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = time;
        event.dataType = transferData;
        this.notifyListeners(2001, event);
        Transfer transfer = null;
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transferAgent = this.transferAgents[i];
            if (transferAgent != null && transferAgent.isSupportedType(transferData)) {
                transfer = transferAgent;
                break;
            }
            ++i;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.result != 1) {
            return;
        }
        OS.gtk_selection_data_set(selection_data, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
    }

    void dragDataDelete(long widget, long context) {
        this.moveData = true;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listeners = this.getListeners(2008);
        int length = listeners.length;
        DragSourceListener[] dragListeners = new DragSourceListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dragListeners[count] = (DragSourceListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dragListeners;
        }
        DragSourceListener[] result = new DragSourceListener[count];
        System.arraycopy(dragListeners, 0, result, 0, count);
        return result;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.targetList != 0L) {
            OS.gtk_target_list_unref(this.targetList);
        }
        this.targetList = 0L;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation |= 2;
        }
        if ((operation & 2) == 2) {
            osOperation |= 4;
        }
        if ((operation & 4) == 4) {
            osOperation |= 8;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 4) == 4) {
            operation |= 2;
        }
        if ((osOperation & 8) == 8) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setDragSourceEffect(DragSourceEffect effect) {
        this.dragEffect = effect;
    }

    public void setTransfer(Transfer[] transferAgents) {
        if (this.targetList != 0L) {
            OS.gtk_target_list_unref(this.targetList);
            this.targetList = 0L;
        }
        this.transferAgents = transferAgents;
        if (transferAgents == null || transferAgents.length == 0) {
            return;
        }
        GtkTargetEntry[] targets = new GtkTargetEntry[]{};
        int i = 0;
        while (i < transferAgents.length) {
            Transfer transfer = transferAgents[i];
            if (transfer != null) {
                int[] typeIds = transfer.getTypeIds();
                String[] typeNames = transfer.getTypeNames();
                int j = 0;
                while (j < typeIds.length) {
                    GtkTargetEntry entry = new GtkTargetEntry();
                    byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                    entry.target = OS.g_malloc(buffer.length);
                    OS.memmove(entry.target, buffer, (long)buffer.length);
                    entry.info = typeIds[j];
                    GtkTargetEntry[] newTargets = new GtkTargetEntry[targets.length + 1];
                    System.arraycopy(targets, 0, newTargets, 0, targets.length);
                    newTargets[targets.length] = entry;
                    targets = newTargets;
                    ++j;
                }
            }
            ++i;
        }
        long pTargets = OS.g_malloc(targets.length * GtkTargetEntry.sizeof);
        int i2 = 0;
        while (i2 < targets.length) {
            OS.memmove(pTargets + (long)(i2 * GtkTargetEntry.sizeof), targets[i2], (long)GtkTargetEntry.sizeof);
            ++i2;
        }
        this.targetList = OS.gtk_target_list_new(pTargets, targets.length);
        i2 = 0;
        while (i2 < targets.length) {
            OS.g_free(targets[i2].target);
            ++i2;
        }
    }

    static long createPixbuf(Image image) {
        long pixbuf;
        boolean hasMask;
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, w, h);
        long colormap = OS.gdk_colormap_get_system();
        boolean bl = hasMask = image.mask != 0L && OS.gdk_drawable_get_depth(image.mask) == 1;
        if (hasMask) {
            pixbuf = OS.gdk_pixbuf_new(0, true, 8, w[0], h[0]);
            if (pixbuf == 0L) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
            long maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, w[0], h[0]);
            if (maskPixbuf == 0L) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(maskPixbuf, image.mask, 0L, 0, 0, 0, 0, w[0], h[0]);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            byte[] line = new byte[stride];
            int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
            long maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
            byte[] maskLine = new byte[maskStride];
            int y = 0;
            while (y < h[0]) {
                long offset = pixels + (long)(y * stride);
                OS.memmove(line, offset, (long)stride);
                long maskOffset = maskPixels + (long)(y * maskStride);
                OS.memmove(maskLine, maskOffset, (long)maskStride);
                int x = 0;
                while (x < w[0]) {
                    if (maskLine[x * 3] == 0) {
                        line[x * 4 + 3] = 0;
                    }
                    ++x;
                }
                OS.memmove(offset, line, (long)stride);
                ++y;
            }
            OS.g_object_unref(maskPixbuf);
        } else {
            ImageData data = image.getImageData();
            boolean hasAlpha = data.getTransparencyType() == 1;
            pixbuf = OS.gdk_pixbuf_new(0, hasAlpha, 8, w[0], h[0]);
            if (pixbuf == 0L) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
            if (hasAlpha) {
                byte[] alpha = data.alphaData;
                int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                long pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                byte[] line = new byte[stride];
                int y = 0;
                while (y < h[0]) {
                    long offset = pixels + (long)(y * stride);
                    OS.memmove(line, offset, (long)stride);
                    int x = 0;
                    while (x < w[0]) {
                        line[x * 4 + 3] = alpha[y * w[0] + x];
                        ++x;
                    }
                    OS.memmove(offset, line, (long)stride);
                    ++y;
                }
            }
        }
        return pixbuf;
    }
}

