/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.searcher.widget;

import jp.sourceforge.concierge.plugin.searcher.SearchCalendar;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DateComposite
extends Composite {
    private static final String strYear = "/";
    private static final String strMonth = "/";
    private static final String strDay = " ";
    private static final int start_year = 1970;
    private SearchCalendar calendar;
    private int day_of_now;
    private int month_of_now;
    private int year_of_now;
    private Combo yearComb = null;
    private Combo monthComb = null;
    private Combo dayComb = null;
    private Label yearLabel = null;
    private Label monthLabel = null;
    private Label dayLabel = null;

    public void getDate(SearchCalendar out) {
        String syear = "";
        if (this.yearComb.getSelectionIndex() >= 0) {
            syear = this.yearComb.getItem(this.yearComb.getSelectionIndex());
        }
        String smonth = "";
        if (this.monthComb.getSelectionIndex() >= 0) {
            smonth = this.monthComb.getItem(this.monthComb.getSelectionIndex());
        }
        String sday = "";
        if (this.dayComb.getSelectionIndex() >= 0) {
            sday = this.dayComb.getItem(this.dayComb.getSelectionIndex());
        }
        out.set(Integer.parseInt(syear), Integer.parseInt(smonth) - 1, Integer.parseInt(sday));
    }

    public void setDate(SearchCalendar in) {
        this.setDay(in.get(5));
        this.setMonth(in.get(2) + 1);
        this.setYear(in.get(1));
    }

    public int getYear() {
        String str = this.yearComb.getItem(this.yearComb.getSelectionIndex());
        return Integer.parseInt(str);
    }

    public int getMonth() {
        String str = this.monthComb.getItem(this.monthComb.getSelectionIndex());
        return Integer.parseInt(str);
    }

    public int getDay() {
        String str = this.dayComb.getItem(this.dayComb.getSelectionIndex());
        return Integer.parseInt(str);
    }

    public void setDate(int year, int month, int day) {
        this.setDay(day);
        this.setMonth(month);
        this.setYear(year);
    }

    public void setSelectable(boolean b) {
        if (b) {
            this.yearComb.setEnabled(true);
            this.monthComb.setEnabled(true);
            this.dayComb.setEnabled(true);
            this.yearLabel.setEnabled(true);
            this.monthLabel.setEnabled(true);
            this.dayLabel.setEnabled(true);
        } else {
            this.yearComb.setEnabled(false);
            this.monthComb.setEnabled(false);
            this.dayComb.setEnabled(false);
            this.yearLabel.setEnabled(false);
            this.monthLabel.setEnabled(false);
            this.dayLabel.setEnabled(false);
        }
    }

    public DateComposite(Composite parent) {
        super(parent, 0);
        this.setLayoutData(new GridData(1808));
        this.calendar = new SearchCalendar();
        this.year_of_now = this.calendar.get(1);
        assert (this.year_of_now > 0);
        this.month_of_now = this.calendar.get(2) + 1;
        assert (1 <= this.month_of_now);
        assert (this.month_of_now <= 12);
        this.day_of_now = this.calendar.get(5);
        assert (1 <= this.day_of_now);
        assert (this.day_of_now <= 31);
        this.yearComb = new Combo((Composite)this, 8);
        FormData fd1 = new FormData();
        fd1.top = new FormAttachment(0, 0);
        fd1.left = new FormAttachment(0, 0);
        fd1.bottom = new FormAttachment(100, 0);
        this.yearComb.setLayoutData((Object)fd1);
        this.initYear(this.yearComb);
        this.yearLabel = new Label((Composite)this, 0);
        this.yearLabel.setText("/");
        FormData fd2 = new FormData();
        fd2.top = new FormAttachment(0, 5);
        fd2.left = new FormAttachment((Control)this.yearComb, 0);
        this.yearLabel.setLayoutData((Object)fd2);
        this.monthComb = new Combo((Composite)this, 8);
        FormData fd3 = new FormData();
        fd3.top = new FormAttachment(0, 0);
        fd3.left = new FormAttachment((Control)this.yearLabel, 0);
        fd3.bottom = new FormAttachment(100, 0);
        this.monthComb.setLayoutData((Object)fd3);
        this.initMonth(this.monthComb);
        this.monthLabel = new Label((Composite)this, 0);
        this.monthLabel.setText("/");
        FormData fd4 = new FormData();
        fd4.top = new FormAttachment(0, 5);
        fd4.left = new FormAttachment((Control)this.monthComb, 0);
        this.monthLabel.setLayoutData((Object)fd4);
        this.dayComb = new Combo((Composite)this, 8);
        FormData fd5 = new FormData();
        fd5.top = new FormAttachment(0, 0);
        fd5.left = new FormAttachment((Control)this.monthLabel, 0);
        fd5.bottom = new FormAttachment(100, 0);
        this.dayComb.setLayoutData((Object)fd5);
        this.initDay(this.dayComb);
        this.dayLabel = new Label((Composite)this, 0);
        this.dayLabel.setText(strDay);
        FormData fd6 = new FormData();
        fd6.top = new FormAttachment(0, 5);
        fd6.left = new FormAttachment((Control)this.dayComb, 0);
        fd6.right = new FormAttachment(100, 0);
        this.dayLabel.setLayoutData((Object)fd6);
        this.setSelectable(true);
    }

    private void initMonth(Combo comb) {
        comb.setItems(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
        this.setMonth(this.month_of_now);
    }

    private void initDay(Combo comb) {
        comb.setItems(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"});
        this.setDay(this.day_of_now);
    }

    private void initYear(Combo comb) {
        int i = 1970;
        while (i <= this.year_of_now) {
            String str = String.valueOf(i);
            comb.add(str);
            ++i;
        }
        this.setYear(this.year_of_now);
    }

    private void setDay(int day) {
        if (day < 1 || 31 < day) {
            return;
        }
        this.dayComb.select(day - 1);
    }

    private void setMonth(int month) {
        if (month < 1 || 12 < month) {
            return;
        }
        this.monthComb.select(month - 1);
    }

    private void setYear(int year) {
        if (year < 1970 || this.year_of_now < year) {
            return;
        }
        this.yearComb.select(year - 1970);
    }
}

