/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class MultiplexingURLStreamHandler
extends URLStreamHandler {
    private static Method openConnectionMethod;
    private static Method equalsMethod;
    private static Method getDefaultPortMethod;
    private static Method getHostAddressMethod;
    private static Method hashCodeMethod;
    private static Method hostsEqualMethod;
    private static Method parseURLMethod;
    private static Method sameFileMethod;
    private static Method setURLMethod;
    private static Method toExternalFormMethod;
    private static Field handlerField;
    private static boolean methodsInitialized;
    private String protocol;
    private StreamHandlerFactory factory;

    static {
        methodsInitialized = false;
    }

    private static synchronized void initializeMethods(StreamHandlerFactory factory) {
        if (methodsInitialized) {
            return;
        }
        try {
            openConnectionMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            openConnectionMethod.setAccessible(true);
            equalsMethod = URLStreamHandler.class.getDeclaredMethod("equals", URL.class, URL.class);
            equalsMethod.setAccessible(true);
            getDefaultPortMethod = URLStreamHandler.class.getDeclaredMethod("getDefaultPort", null);
            getDefaultPortMethod.setAccessible(true);
            getHostAddressMethod = URLStreamHandler.class.getDeclaredMethod("getHostAddress", URL.class);
            getHostAddressMethod.setAccessible(true);
            hashCodeMethod = URLStreamHandler.class.getDeclaredMethod("hashCode", URL.class);
            hashCodeMethod.setAccessible(true);
            hostsEqualMethod = URLStreamHandler.class.getDeclaredMethod("hostsEqual", URL.class, URL.class);
            hostsEqualMethod.setAccessible(true);
            parseURLMethod = URLStreamHandler.class.getDeclaredMethod("parseURL", URL.class, String.class, Integer.TYPE, Integer.TYPE);
            parseURLMethod.setAccessible(true);
            sameFileMethod = URLStreamHandler.class.getDeclaredMethod("sameFile", URL.class, URL.class);
            sameFileMethod.setAccessible(true);
            setURLMethod = URLStreamHandler.class.getDeclaredMethod("setURL", URL.class, String.class, String.class, Integer.TYPE, String.class, String.class, String.class, String.class, String.class);
            setURLMethod.setAccessible(true);
            toExternalFormMethod = URLStreamHandler.class.getDeclaredMethod("toExternalForm", URL.class);
            toExternalFormMethod.setAccessible(true);
            handlerField = URL.class.getDeclaredField("handler");
            handlerField.setAccessible(true);
        }
        catch (Exception e) {
            factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "initializeMethods", 4, e, null));
            throw new RuntimeException(e.getMessage());
        }
        methodsInitialized = true;
    }

    public MultiplexingURLStreamHandler(String protocol, StreamHandlerFactory factory) {
        this.protocol = protocol;
        this.factory = factory;
        MultiplexingURLStreamHandler.initializeMethods(factory);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (URLConnection)openConnectionMethod.invoke((Object)handler, url);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "openConnection", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new MalformedURLException();
    }

    @Override
    protected boolean equals(URL url1, URL url2) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Boolean)equalsMethod.invoke((Object)handler, url1, url2);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "equals", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected int getDefaultPort() {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Integer)getDefaultPortMethod.invoke((Object)handler, null);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "getDefaultPort", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected InetAddress getHostAddress(URL url) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (InetAddress)getHostAddressMethod.invoke((Object)handler, url);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "hashCode", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected int hashCode(URL url) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Integer)hashCodeMethod.invoke((Object)handler, url);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "hashCode", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean hostsEqual(URL url1, URL url2) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Boolean)hostsEqualMethod.invoke((Object)handler, url1, url2);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "hostsEqual", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void parseURL(URL arg0, String arg1, int arg2, int arg3) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                handlerField.set(arg0, handler);
                parseURLMethod.invoke((Object)handler, arg0, arg1, new Integer(arg2), new Integer(arg3));
                return;
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "parseURL", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected boolean sameFile(URL url1, URL url2) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (Boolean)sameFileMethod.invoke((Object)handler, url1, url2);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "sameFile", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected void setURL(URL arg0, String arg1, String arg2, int arg3, String arg4, String arg5, String arg6, String arg7, String arg8) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                handlerField.set(arg0, handler);
                setURLMethod.invoke((Object)handler, arg0, arg1, arg2, new Integer(arg3), arg4, arg5, arg6, arg7, arg8);
                return;
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "setURL", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected String toExternalForm(URL url) {
        URLStreamHandler handler = this.factory.findAuthorizedURLStreamHandler(this.protocol);
        if (handler != null) {
            try {
                return (String)toExternalFormMethod.invoke((Object)handler, url);
            }
            catch (Exception e) {
                this.factory.adaptor.getFrameworkLog().log(new FrameworkLogEntry(MultiplexingURLStreamHandler.class.getName(), "toExternalForm", 4, e, null));
                throw new RuntimeException(e.getMessage());
            }
        }
        throw new IllegalStateException();
    }
}

