/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.internal.filesystem.NullFileSystem;
import org.eclipse.core.internal.filesystem.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class NullFileStore
extends FileStore {
    private IPath path;

    public NullFileStore(IPath path) {
        this.path = path;
    }

    @Override
    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) {
        return EMPTY_FILE_INFO_ARRAY;
    }

    @Override
    public String[] childNames(int options, IProgressMonitor monitor) {
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        super.delete(options, monitor);
    }

    @Override
    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        FileInfo result = new FileInfo(this.getName());
        result.setExists(false);
        return result;
    }

    @Override
    public IFileStore getChild(String name) {
        return new NullFileStore(this.path.append(name));
    }

    @Override
    public IFileSystem getFileSystem() {
        return NullFileSystem.getInstance();
    }

    @Override
    public String getName() {
        return String.valueOf(this.path.lastSegment());
    }

    @Override
    public IFileStore getParent() {
        return this.path.segmentCount() == 0 ? null : new NullFileStore(this.path.removeLastSegments(1));
    }

    @Override
    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        return super.mkdir(options, monitor);
    }

    @Override
    public InputStream openInputStream(int options, IProgressMonitor monitor) {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public OutputStream openOutputStream(int options, IProgressMonitor monitor) {
        return new OutputStream(){

            @Override
            public void write(int b) {
            }
        };
    }

    @Override
    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        super.putInfo(info, options, monitor);
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    @Override
    public URI toURI() {
        try {
            return new URI("null", null, this.path.isEmpty() ? "/" : this.path.toString(), null);
        }
        catch (URISyntaxException e) {
            Policy.log(4, "Invalid URI", e);
            return null;
        }
    }
}

